/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad;

import com.azure.spring.cloud.autoconfigure.aad.implementation.jwt.AadJwtGrantedAuthoritiesConverter;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadResourceServerProperties;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AadResourceServerWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AadResourceServerProperties properties;
    private Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter;

    public AadResourceServerWebSecurityConfigurerAdapter() {
    }

    public AadResourceServerWebSecurityConfigurerAdapter(AadResourceServerProperties properties, Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        Assert.notNull(jwtGrantedAuthoritiesConverter, (String)"jwtGrantedAuthoritiesConverter cannot be null");
        this.properties = properties;
        this.jwtGrantedAuthoritiesConverter = jwtGrantedAuthoritiesConverter;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.jwtAuthenticationConverter());
    }

    private Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        if (StringUtils.hasText((String)this.properties.getPrincipalClaimName())) {
            converter.setPrincipalClaimName(this.properties.getPrincipalClaimName());
        }
        this.jwtGrantedAuthoritiesConverter = this.jwtGrantedAuthoritiesConverter();
        if (this.jwtGrantedAuthoritiesConverter != null) {
            converter.setJwtGrantedAuthoritiesConverter(this.jwtGrantedAuthoritiesConverter);
        } else {
            converter.setJwtGrantedAuthoritiesConverter((Converter)new AadJwtGrantedAuthoritiesConverter(this.properties.getClaimToAuthorityPrefixMap()));
        }
        return converter;
    }

    protected Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter() {
        return this.jwtGrantedAuthoritiesConverter;
    }
}

