/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.cloud.autoconfigure.servicebus.AzureServiceBusAutoConfiguration;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.azure.spring.messaging.servicebus.core.DefaultServiceBusNamespaceProcessorFactory;
import com.azure.spring.messaging.servicebus.core.DefaultServiceBusNamespaceProducerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProcessorFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusTemplate;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.core.properties.ProcessorProperties;
import com.azure.spring.messaging.servicebus.core.properties.ProducerProperties;
import com.azure.spring.messaging.servicebus.support.converter.ServiceBusMessageConverter;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ServiceBusTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.azure.servicebus.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"connection-string", "namespace"})
@ConditionalOnBean(value={AzureServiceBusProperties.class})
@AutoConfigureAfter(value={AzureServiceBusAutoConfiguration.class})
@Import(value={ServiceBusTemplateConfiguration.class, ProcessorContainerConfiguration.class})
public class AzureServiceBusMessagingAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureServiceBusMessagingAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    NamespaceProperties serviceBusNamespaceProperties(AzureServiceBusProperties properties, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders) {
        ServiceConnectionStringProvider connectionStringProvider;
        NamespaceProperties namespaceProperties = new NamespaceProperties();
        BeanUtils.copyProperties((Object)properties, (Object)namespaceProperties);
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)properties, (AzureProperties)namespaceProperties);
        if (namespaceProperties.getConnectionString() == null && (connectionStringProvider = (ServiceConnectionStringProvider)connectionStringProviders.getIfAvailable()) != null) {
            namespaceProperties.setConnectionString(connectionStringProvider.getConnectionString());
            LOGGER.info("Service Bus connection string is set from {} now.", (Object)connectionStringProvider.getClass().getName());
        }
        return namespaceProperties;
    }

    @Configuration(proxyBeanMethods=false)
    public static class ServiceBusTemplateConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProducerFactory defaultServiceBusNamespaceProducerFactory(NamespaceProperties properties, ObjectProvider<PropertiesSupplier<String, ProducerProperties>> suppliers) {
            return new DefaultServiceBusNamespaceProducerFactory(properties, (PropertiesSupplier)suppliers.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.azure.message-converter.isolated-object-mapper"}, havingValue="true", matchIfMissing=true)
        ServiceBusMessageConverter defaultServiceBusMessageConverter() {
            return new ServiceBusMessageConverter(ObjectMapperHolder.OBJECT_MAPPER);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.azure.message-converter.isolated-object-mapper"}, havingValue="false")
        ServiceBusMessageConverter serviceBusMessageConverter(ObjectMapper objectMapper) {
            return new ServiceBusMessageConverter(objectMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ServiceBusProducerFactory.class})
        public ServiceBusTemplate serviceBusTemplate(ServiceBusProducerFactory senderClientfactory, ServiceBusMessageConverter messageConverter) {
            ServiceBusTemplate serviceBusTemplate = new ServiceBusTemplate(senderClientfactory);
            serviceBusTemplate.setMessageConverter(messageConverter);
            return serviceBusTemplate;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class ProcessorContainerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorFactory defaultServiceBusNamespaceProcessorFactory(NamespaceProperties properties, ObjectProvider<PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>> suppliers) {
            return new DefaultServiceBusNamespaceProcessorFactory(properties, (PropertiesSupplier)suppliers.getIfAvailable());
        }
    }
}

