/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.context;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class AzureGlobalConfigurationEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final Log logger;

    public AzureGlobalConfigurationEnvironmentPostProcessor(Log logger) {
        this.logger = logger;
        AzureCoreEnvMapping.setLogger(logger);
    }

    public AzureGlobalConfigurationEnvironmentPostProcessor() {
        this.logger = new DeferredLog();
        AzureCoreEnvMapping.setLogger(this.logger);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String property;
        HashMap<String, Object> source = new HashMap<String, Object>();
        for (AzureCoreEnvMapping azureCoreEnvMapping : AzureCoreEnvMapping.values()) {
            if (!environment.containsProperty(azureCoreEnvMapping.coreEnvName)) continue;
            property = environment.getProperty(azureCoreEnvMapping.coreEnvName);
            source.put(azureCoreEnvMapping.springPropertyName, azureCoreEnvMapping.converter.apply(property));
        }
        for (Enum enum_ : AzureSdkEnvMapping.values()) {
            if (!environment.containsProperty(((AzureSdkEnvMapping)enum_).sdkEnvName)) continue;
            property = environment.getProperty(((AzureSdkEnvMapping)enum_).sdkEnvName);
            source.put(((AzureSdkEnvMapping)enum_).springPropertyName, ((AzureSdkEnvMapping)enum_).converter.apply(property));
        }
        if (!source.isEmpty()) {
            environment.getPropertySources().addLast((PropertySource)new AzureCoreEnvPropertySource("Azure Core/SDK", source));
        } else {
            this.logger.debug((Object)"No env predefined by Azure Core/SDKs are set, skip adding the AzureCoreEnvPropertySource.");
        }
    }

    static enum AzureCoreEnvMapping {
        CLIENT_ID("AZURE_CLIENT_ID", "credential.client-id"),
        CLIENT_SECRET("AZURE_CLIENT_SECRET", "credential.client-secret"),
        CLIENT_CERTIFICATE_PATH("AZURE_CLIENT_CERTIFICATE_PATH", "credential.client-certificate-path"),
        CLIENT_CERTIFICATE_PASSWORD("AZURE_CLIENT_CERTIFICATE_PASSWORD", "credential.client-certificate-password"),
        USERNAME("AZURE_USERNAME", "credential.username"),
        PASSWORD("AZURE_PASSWORD", "credential.password"),
        TENANT_ID("AZURE_TENANT_ID", "profile.tenant-id"),
        SUBSCRIPTION_ID("AZURE_SUBSCRIPTION_ID", "profile.subscription-id"),
        AZURE_CLOUD("AZURE_CLOUD", "profile.cloud-type"),
        AUTHORITY_HOST("AZURE_AUTHORITY_HOST", "profile.environment.active-directory-endpoint"),
        MAX_FIXED_RETRY("AZURE_REQUEST_RETRY_COUNT", "retry.exponential.max-retries"),
        MAX_EXPONENTIAL_RETRY("AZURE_REQUEST_RETRY_COUNT", "retry.fixed.max-retries"),
        HTTP_LOG_LEVEL("AZURE_HTTP_LOG_DETAIL_LEVEL", "client.http.logging.level"),
        HTTP_CONNECT_TIMEOUT("AZURE_REQUEST_CONNECT_TIMEOUT", "client.http.connect-timeout", AzureCoreEnvMapping.convertMillisToDuration()),
        HTTP_READ_TIMEOUT("AZURE_REQUEST_READ_TIMEOUT", "client.http.read-timeout", AzureCoreEnvMapping.convertMillisToDuration()),
        HTTP_WRITE_TIMEOUT("AZURE_REQUEST_WRITE_TIMEOUT", "client.http.write-timeout", AzureCoreEnvMapping.convertMillisToDuration()),
        HTTP_RESPONSE_TIMEOUT("AZURE_REQUEST_RESPONSE_TIMEOUT", "client.http.response-timeout", AzureCoreEnvMapping.convertMillisToDuration()),
        HTTP_NO_PROXY("NO_PROXY", "proxy.http.non-proxy-hosts");

        private static Log logger;
        private final String coreEnvName;
        private final String springPropertyName;
        private final Function<String, Object> converter;

        private AzureCoreEnvMapping(String coreEnvName, String springPropertyName) {
            this(coreEnvName, springPropertyName, a -> a);
        }

        private AzureCoreEnvMapping(String coreEnvName, String springPropertyName, Function<String, Object> converter) {
            this.coreEnvName = coreEnvName;
            this.springPropertyName = "spring.cloud.azure." + springPropertyName;
            this.converter = converter;
        }

        private static Function<String, Object> convertMillisToDuration() {
            return ms -> {
                try {
                    return Duration.ofMillis(Integer.parseInt(ms));
                }
                catch (Exception ignore) {
                    logger.debug((Object)("The millisecond value " + ms + " is malformed."));
                    return null;
                }
            };
        }

        private static void setLogger(Log logger) {
            AzureCoreEnvMapping.logger = logger;
        }
    }

    static enum AzureSdkEnvMapping {
        KEY_VAULT_SECRET_ENDPOINT("AZURE_KEYVAULT_ENDPOINT", "keyvault.secret.endpoint"),
        KEY_VAULT_CERTIFICATE_ENDPOINT("AZURE_KEYVAULT_ENDPOINT", "keyvault.certificate.endpoint"),
        EVENT_HUBS_CONNECTION_STRING("AZURE_EVENT_HUBS_CONNECTION_STRING", "eventhubs.connection-string");

        private final String sdkEnvName;
        private final String springPropertyName;
        private final Function<String, Object> converter;

        private AzureSdkEnvMapping(String sdkEnvName, String springPropertyName) {
            this(sdkEnvName, springPropertyName, a -> a);
        }

        private AzureSdkEnvMapping(String sdkEnvName, String springPropertyName, Function<String, Object> converter) {
            this.sdkEnvName = sdkEnvName;
            this.springPropertyName = "spring.cloud.azure." + springPropertyName;
            this.converter = converter;
        }
    }

    private static class AzureCoreEnvPropertySource
    extends MapPropertySource {
        AzureCoreEnvPropertySource(String name, Map<String, Object> source) {
            super(name, source);
        }
    }
}

