/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.configuration;

import com.azure.spring.cloud.autoconfigure.aad.AadClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.ClientRegistrationCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.ResourceServerWithOBOCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.WebApplicationAndResourceServerCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.WebApplicationWithoutResourceServerCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.JacksonHttpSessionOAuth2AuthorizedClientRepository;
import com.azure.spring.cloud.autoconfigure.aad.implementation.webapi.AadOboOAuth2AuthorizedClientProvider;
import com.azure.spring.cloud.autoconfigure.aad.implementation.webapp.AadAzureDelegatedOAuth2AuthorizedClientProvider;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@Configuration(proxyBeanMethods=false)
public class AadOAuth2ClientConfiguration {

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={WebApplicationAndResourceServerCondition.class})
    public static class WebApplicationAndResourceServiceOAuth2AuthorizedClientManagerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrations, OAuth2AuthorizedClientRepository authorizedClients) {
            DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clientRegistrations, authorizedClients);
            AadAzureDelegatedOAuth2AuthorizedClientProvider azureDelegatedProvider = new AadAzureDelegatedOAuth2AuthorizedClientProvider(new RefreshTokenOAuth2AuthorizedClientProvider(), authorizedClients);
            AadOboOAuth2AuthorizedClientProvider oboProvider = new AadOboOAuth2AuthorizedClientProvider();
            OAuth2AuthorizedClientProvider authorizedClientProviders = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().provider((OAuth2AuthorizedClientProvider)azureDelegatedProvider).provider((OAuth2AuthorizedClientProvider)oboProvider).build();
            manager.setAuthorizedClientProvider(authorizedClientProviders);
            return manager;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={ResourceServerWithOBOCondition.class})
    public static class ResourceServerWithOBOOAuth2AuthorizedClientManagerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrations, OAuth2AuthorizedClientRepository authorizedClients) {
            DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clientRegistrations, authorizedClients);
            AadOboOAuth2AuthorizedClientProvider oboProvider = new AadOboOAuth2AuthorizedClientProvider();
            OAuth2AuthorizedClientProvider authorizedClientProviders = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().provider((OAuth2AuthorizedClientProvider)oboProvider).build();
            manager.setAuthorizedClientProvider(authorizedClientProviders);
            return manager;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={WebApplicationWithoutResourceServerCondition.class})
    public static class WebApplicationWithoutResourceServerOAuth2AuthorizedClientManagerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrations, OAuth2AuthorizedClientRepository authorizedClients) {
            DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clientRegistrations, authorizedClients);
            AadAzureDelegatedOAuth2AuthorizedClientProvider azureDelegatedProvider = new AadAzureDelegatedOAuth2AuthorizedClientProvider(new RefreshTokenOAuth2AuthorizedClientProvider(), authorizedClients);
            OAuth2AuthorizedClientProvider authorizedClientProviders = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().provider((OAuth2AuthorizedClientProvider)azureDelegatedProvider).build();
            manager.setAuthorizedClientProvider(authorizedClientProviders);
            return manager;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={ClientRegistrationCondition.class})
    public static class OAuth2ClientRepositoryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ClientRegistrationRepository clientRegistrationRepository(AadAuthenticationProperties properties) {
            return new AadClientRegistrationRepository(properties);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository() {
            return new JacksonHttpSessionOAuth2AuthorizedClientRepository();
        }
    }
}

