/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.properties;

import com.azure.core.management.AzureEnvironment;
import com.azure.spring.cloud.core.properties.profile.AzureProfileOptionsAdapter;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;

public class AadProfileEnvironmentProperties {
    private String activeDirectoryEndpoint;
    private String microsoftGraphEndpoint;

    public String getActiveDirectoryEndpoint() {
        return this.activeDirectoryEndpoint;
    }

    public void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
        this.activeDirectoryEndpoint = this.addSlash(activeDirectoryEndpoint);
    }

    public String getMicrosoftGraphEndpoint() {
        return this.microsoftGraphEndpoint;
    }

    public void setMicrosoftGraphEndpoint(String microsoftGraphEndpoint) {
        this.microsoftGraphEndpoint = this.addSlash(microsoftGraphEndpoint);
    }

    public void updatePropertiesByCloudType(AzureProfileOptionsProvider.CloudType cloudType) {
        AzureEnvironment knownAzureEnvironment = AzureProfileOptionsAdapter.decideAzureManagementEnvironment((AzureProfileOptionsProvider.CloudType)cloudType, (AzureEnvironment)AzureEnvironment.AZURE);
        if (this.activeDirectoryEndpoint == null) {
            this.activeDirectoryEndpoint = knownAzureEnvironment.getActiveDirectoryEndpoint();
        }
        if (this.microsoftGraphEndpoint == null) {
            this.microsoftGraphEndpoint = knownAzureEnvironment.getMicrosoftGraphEndpoint();
        }
    }

    private String addSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }
}

