/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.properties.core.profile;

import com.azure.core.management.AzureEnvironment;
import com.azure.spring.cloud.core.properties.profile.AzureProfileOptionsAdapter;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;

public class AzureProfileConfigurationProperties
extends AzureProfileOptionsAdapter {
    private String tenantId;
    private String subscriptionId;
    private AzureProfileOptionsProvider.CloudType cloudType = AzureProfileOptionsProvider.CloudType.AZURE;
    private final AzureEnvironmentConfigurationProperties environment = new AzureEnvironmentConfigurationProperties(AzureEnvironment.AZURE);

    public AzureProfileOptionsProvider.CloudType getCloudType() {
        return this.cloudType;
    }

    public void setCloudType(AzureProfileOptionsProvider.CloudType cloudType) {
        this.cloudType = cloudType;
        this.changeEnvironmentAccordingToCloud();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public AzureEnvironmentConfigurationProperties getEnvironment() {
        return this.environment;
    }

    public static final class AzureEnvironmentConfigurationProperties
    implements AzureProfileOptionsProvider.AzureEnvironmentOptions {
        private String portal;
        private String publishingProfile;
        private String managementEndpoint;
        private String resourceManagerEndpoint;
        private String sqlManagementEndpoint;
        private String sqlServerHostnameSuffix;
        private String galleryEndpoint;
        private String activeDirectoryEndpoint;
        private String activeDirectoryResourceId;
        private String activeDirectoryGraphEndpoint;
        private String activeDirectoryGraphApiVersion;
        private String microsoftGraphEndpoint;
        private String dataLakeEndpointResourceId;
        private String storageEndpointSuffix;
        private String keyVaultDnsSuffix;
        private String azureDataLakeStoreFileSystemEndpointSuffix;
        private String azureDataLakeAnalyticsCatalogAndJobEndpointSuffix;
        private String azureLogAnalyticsEndpoint;
        private String azureApplicationInsightsEndpoint;

        public String getPortal() {
            return this.portal;
        }

        public void setPortal(String portal) {
            this.portal = portal;
        }

        public String getPublishingProfile() {
            return this.publishingProfile;
        }

        public void setPublishingProfile(String publishingProfile) {
            this.publishingProfile = publishingProfile;
        }

        public String getManagementEndpoint() {
            return this.managementEndpoint;
        }

        public void setManagementEndpoint(String managementEndpoint) {
            this.managementEndpoint = managementEndpoint;
        }

        public String getResourceManagerEndpoint() {
            return this.resourceManagerEndpoint;
        }

        public void setResourceManagerEndpoint(String resourceManagerEndpoint) {
            this.resourceManagerEndpoint = resourceManagerEndpoint;
        }

        public String getSqlManagementEndpoint() {
            return this.sqlManagementEndpoint;
        }

        public void setSqlManagementEndpoint(String sqlManagementEndpoint) {
            this.sqlManagementEndpoint = sqlManagementEndpoint;
        }

        public String getSqlServerHostnameSuffix() {
            return this.sqlServerHostnameSuffix;
        }

        public void setSqlServerHostnameSuffix(String sqlServerHostnameSuffix) {
            this.sqlServerHostnameSuffix = sqlServerHostnameSuffix;
        }

        public String getGalleryEndpoint() {
            return this.galleryEndpoint;
        }

        public void setGalleryEndpoint(String galleryEndpoint) {
            this.galleryEndpoint = galleryEndpoint;
        }

        public String getActiveDirectoryEndpoint() {
            return this.activeDirectoryEndpoint;
        }

        public void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
            this.activeDirectoryEndpoint = activeDirectoryEndpoint;
        }

        public String getActiveDirectoryResourceId() {
            return this.activeDirectoryResourceId;
        }

        public void setActiveDirectoryResourceId(String activeDirectoryResourceId) {
            this.activeDirectoryResourceId = activeDirectoryResourceId;
        }

        public String getActiveDirectoryGraphEndpoint() {
            return this.activeDirectoryGraphEndpoint;
        }

        public void setActiveDirectoryGraphEndpoint(String activeDirectoryGraphEndpoint) {
            this.activeDirectoryGraphEndpoint = activeDirectoryGraphEndpoint;
        }

        public String getActiveDirectoryGraphApiVersion() {
            return this.activeDirectoryGraphApiVersion;
        }

        public void setActiveDirectoryGraphApiVersion(String activeDirectoryGraphApiVersion) {
            this.activeDirectoryGraphApiVersion = activeDirectoryGraphApiVersion;
        }

        public String getMicrosoftGraphEndpoint() {
            return this.microsoftGraphEndpoint;
        }

        public void setMicrosoftGraphEndpoint(String microsoftGraphEndpoint) {
            this.microsoftGraphEndpoint = microsoftGraphEndpoint;
        }

        public String getDataLakeEndpointResourceId() {
            return this.dataLakeEndpointResourceId;
        }

        public void setDataLakeEndpointResourceId(String dataLakeEndpointResourceId) {
            this.dataLakeEndpointResourceId = dataLakeEndpointResourceId;
        }

        public String getStorageEndpointSuffix() {
            return this.storageEndpointSuffix;
        }

        public void setStorageEndpointSuffix(String storageEndpointSuffix) {
            this.storageEndpointSuffix = storageEndpointSuffix;
        }

        public String getKeyVaultDnsSuffix() {
            return this.keyVaultDnsSuffix;
        }

        public void setKeyVaultDnsSuffix(String keyVaultDnsSuffix) {
            this.keyVaultDnsSuffix = keyVaultDnsSuffix;
        }

        public String getAzureDataLakeStoreFileSystemEndpointSuffix() {
            return this.azureDataLakeStoreFileSystemEndpointSuffix;
        }

        public void setAzureDataLakeStoreFileSystemEndpointSuffix(String azureDataLakeStoreFileSystemEndpointSuffix) {
            this.azureDataLakeStoreFileSystemEndpointSuffix = azureDataLakeStoreFileSystemEndpointSuffix;
        }

        public String getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix() {
            return this.azureDataLakeAnalyticsCatalogAndJobEndpointSuffix;
        }

        public void setAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix(String azureDataLakeAnalyticsCatalogAndJobEndpointSuffix) {
            this.azureDataLakeAnalyticsCatalogAndJobEndpointSuffix = azureDataLakeAnalyticsCatalogAndJobEndpointSuffix;
        }

        public String getAzureLogAnalyticsEndpoint() {
            return this.azureLogAnalyticsEndpoint;
        }

        public void setAzureLogAnalyticsEndpoint(String azureLogAnalyticsEndpoint) {
            this.azureLogAnalyticsEndpoint = azureLogAnalyticsEndpoint;
        }

        public String getAzureApplicationInsightsEndpoint() {
            return this.azureApplicationInsightsEndpoint;
        }

        public void setAzureApplicationInsightsEndpoint(String azureApplicationInsightsEndpoint) {
            this.azureApplicationInsightsEndpoint = azureApplicationInsightsEndpoint;
        }

        private AzureEnvironmentConfigurationProperties(AzureEnvironment azureEnvironment) {
            if (azureEnvironment == null) {
                return;
            }
            this.portal = azureEnvironment.getPortal();
            this.publishingProfile = azureEnvironment.getPublishingProfile();
            this.managementEndpoint = azureEnvironment.getManagementEndpoint();
            this.resourceManagerEndpoint = azureEnvironment.getResourceManagerEndpoint();
            this.sqlManagementEndpoint = azureEnvironment.getSqlManagementEndpoint();
            this.sqlServerHostnameSuffix = azureEnvironment.getSqlServerHostnameSuffix();
            this.galleryEndpoint = azureEnvironment.getGalleryEndpoint();
            this.activeDirectoryEndpoint = azureEnvironment.getActiveDirectoryEndpoint();
            this.activeDirectoryResourceId = azureEnvironment.getActiveDirectoryResourceId();
            this.activeDirectoryGraphEndpoint = azureEnvironment.getGraphEndpoint();
            this.activeDirectoryGraphApiVersion = azureEnvironment.getActiveDirectoryGraphApiVersion();
            this.microsoftGraphEndpoint = azureEnvironment.getMicrosoftGraphEndpoint();
            this.dataLakeEndpointResourceId = azureEnvironment.getDataLakeEndpointResourceId();
            this.storageEndpointSuffix = azureEnvironment.getStorageEndpointSuffix();
            this.keyVaultDnsSuffix = azureEnvironment.getKeyVaultDnsSuffix();
            this.azureDataLakeStoreFileSystemEndpointSuffix = azureEnvironment.getAzureDataLakeStoreFileSystemEndpointSuffix();
            this.azureDataLakeAnalyticsCatalogAndJobEndpointSuffix = azureEnvironment.getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix();
            this.azureLogAnalyticsEndpoint = azureEnvironment.getLogAnalyticsEndpoint();
            this.azureApplicationInsightsEndpoint = azureEnvironment.getApplicationInsightsEndpoint();
        }

        public AzureProfileOptionsProvider.AzureEnvironmentOptions fromAzureManagementEnvironment(AzureEnvironment environment) {
            return new AzureEnvironmentConfigurationProperties(environment);
        }
    }
}

