/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation;

import java.util.List;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public final class AadRestTemplateCreator {
    private AadRestTemplateCreator() {
    }

    public static RestTemplate createRestTemplate(RestTemplateBuilder builder) {
        Assert.notNull((Object)builder, (String)"RestTemplateBuilder cannot be null");
        return builder.build();
    }

    public static RestTemplate createOAuth2ErrorResponseHandledRestTemplate(RestTemplateBuilder builder) {
        RestTemplate restTemplate = AadRestTemplateCreator.createRestTemplate(builder);
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        return restTemplate;
    }

    public static RestTemplate createOAuth2AccessTokenResponseClientRestTemplate(RestTemplateBuilder builder) {
        RestTemplate restTemplate = AadRestTemplateCreator.createOAuth2ErrorResponseHandledRestTemplate(builder);
        List converters = restTemplate.getMessageConverters();
        if (AadRestTemplateCreator.notContainsElementOfType(converters, FormHttpMessageConverter.class)) {
            converters.add(new FormHttpMessageConverter());
        }
        if (AadRestTemplateCreator.notContainsElementOfType(converters, OAuth2AccessTokenResponseHttpMessageConverter.class)) {
            converters.add(new OAuth2AccessTokenResponseHttpMessageConverter());
        }
        return restTemplate;
    }

    private static boolean notContainsElementOfType(List<?> list, Class<?> clazz) {
        return list.stream().noneMatch(item -> item.getClass().equals(clazz));
    }
}

