/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.graph;

import com.azure.spring.cloud.autoconfigure.aad.implementation.AadRestTemplateCreator;
import com.azure.spring.cloud.autoconfigure.aad.implementation.graph.GroupInformation;
import com.azure.spring.cloud.autoconfigure.aad.implementation.graph.Membership;
import com.azure.spring.cloud.autoconfigure.aad.implementation.graph.Memberships;
import com.azure.spring.cloud.autoconfigure.aad.implementation.util.JacksonObjectMapperFactory;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClient.class);
    private final AadAuthenticationProperties properties;
    private final RestOperations operations;

    public GraphClient(AadAuthenticationProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this.properties = properties;
        this.operations = AadRestTemplateCreator.createRestTemplate(restTemplateBuilder);
    }

    public GroupInformation getGroupInformation(String accessToken) {
        GroupInformation groupInformation = new GroupInformation();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        String aadMembershipRestUri = this.properties.getGraphMembershipUri();
        while (aadMembershipRestUri != null) {
            Memberships memberships;
            try {
                String membershipsJson = this.getUserMemberships(accessToken, aadMembershipRestUri);
                memberships = (Memberships)objectMapper.readValue(membershipsJson, Memberships.class);
            }
            catch (IOException ioException) {
                LOGGER.error("Can not get group information from graph server.", (Throwable)ioException);
                break;
            }
            for (Membership membership : memberships.getValue()) {
                if (!this.isGroupObject(membership)) continue;
                groupInformation.getGroupsIds().add(membership.getObjectID());
                groupInformation.getGroupsNames().add(membership.getDisplayName());
            }
            aadMembershipRestUri = Optional.of(memberships).map(Memberships::getOdataNextLink).orElse(null);
        }
        return groupInformation;
    }

    private String getUserMemberships(String accessToken, String urlString) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", String.format("Bearer %s", accessToken));
        headers.set("Accept", "application/json");
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.operations.exchange(urlString, HttpMethod.GET, entity, String.class, new Object[0]);
        String responseInJson = (String)response.getBody();
        if (response.getStatusCode() == HttpStatus.OK) {
            return (String)response.getBody();
        }
        throw new IllegalStateException("Response is not 200, response json: " + responseInJson);
    }

    private boolean isGroupObject(Membership membership) {
        return membership.getObjectType().equals("#microsoft.graph.group");
    }
}

