/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureServiceConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.proxy.HttpProxyConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.client.ClientConfigurationProperties;
import com.azure.spring.cloud.service.implementation.cosmos.CosmosClientProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class AzureCosmosProperties
extends AbstractAzureServiceConfigurationProperties
implements CosmosClientProperties {
    public static final String PREFIX = "spring.cloud.azure.cosmos";
    @NestedConfigurationProperty
    private final HttpProxyConfigurationProperties proxy = new HttpProxyConfigurationProperties();
    @NestedConfigurationProperty
    private final ClientConfigurationProperties client = new ClientConfigurationProperties();
    private String endpoint;
    private String key;
    private String database;
    private String resourceToken;
    private Boolean clientTelemetryEnabled;
    private Boolean endpointDiscoveryEnabled;
    private Boolean connectionSharingAcrossClientsEnabled;
    private Boolean contentResponseOnWriteEnabled;
    private Boolean multipleWriteRegionsEnabled;
    private Boolean sessionCapturingOverrideEnabled;
    private Boolean readRequestsFallbackEnabled;
    private final List<String> preferredRegions = new ArrayList<String>();
    @NestedConfigurationProperty
    private final ThrottlingRetryOptions throttlingRetryOptions = new ThrottlingRetryOptions();
    private ConsistencyLevel consistencyLevel;
    private ConnectionMode connectionMode = ConnectionMode.DIRECT;
    private final GatewayConnection gatewayConnection = new GatewayConnection();
    private final DirectConnection directConnection = new DirectConnection();
    private boolean populateQueryMetrics = false;

    public HttpProxyConfigurationProperties getProxy() {
        return this.proxy;
    }

    public ClientConfigurationProperties getClient() {
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getResourceToken() {
        return this.resourceToken;
    }

    public void setResourceToken(String resourceToken) {
        this.resourceToken = resourceToken;
    }

    public Boolean getClientTelemetryEnabled() {
        return this.clientTelemetryEnabled;
    }

    public void setClientTelemetryEnabled(Boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabled = clientTelemetryEnabled;
    }

    public Boolean getEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public void setEndpointDiscoveryEnabled(Boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
    }

    public Boolean getConnectionSharingAcrossClientsEnabled() {
        return this.connectionSharingAcrossClientsEnabled;
    }

    public void setConnectionSharingAcrossClientsEnabled(Boolean connectionSharingAcrossClientsEnabled) {
        this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
    }

    public Boolean getContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public void setContentResponseOnWriteEnabled(Boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
    }

    public Boolean getMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    public void setMultipleWriteRegionsEnabled(Boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
    }

    public Boolean getSessionCapturingOverrideEnabled() {
        return this.sessionCapturingOverrideEnabled;
    }

    public void setSessionCapturingOverrideEnabled(Boolean sessionCapturingOverrideEnabled) {
        this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
    }

    public Boolean getReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public void setReadRequestsFallbackEnabled(Boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
    }

    public List<String> getPreferredRegions() {
        return this.preferredRegions;
    }

    public GatewayConnection getGatewayConnection() {
        return this.gatewayConnection;
    }

    public DirectConnection getDirectConnection() {
        return this.directConnection;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean isPopulateQueryMetrics() {
        return this.populateQueryMetrics;
    }

    public void setPopulateQueryMetrics(boolean populateQueryMetrics) {
        this.populateQueryMetrics = populateQueryMetrics;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
    }

    public ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    public static class GatewayConnection
    implements CosmosClientProperties.GatewayConnectionProperties {
        private Integer maxConnectionPoolSize;
        private Duration idleConnectionTimeout;

        public Integer getMaxConnectionPoolSize() {
            return this.maxConnectionPoolSize;
        }

        public void setMaxConnectionPoolSize(Integer maxConnectionPoolSize) {
            this.maxConnectionPoolSize = maxConnectionPoolSize;
        }

        public Duration getIdleConnectionTimeout() {
            return this.idleConnectionTimeout;
        }

        public void setIdleConnectionTimeout(Duration idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
        }
    }

    public static class DirectConnection
    implements CosmosClientProperties.DirectConnectionProperties {
        private Boolean connectionEndpointRediscoveryEnabled;
        private Duration connectTimeout;
        private Duration idleConnectionTimeout;
        private Duration idleEndpointTimeout;
        private Duration networkRequestTimeout;
        private Integer maxConnectionsPerEndpoint;
        private Integer maxRequestsPerConnection;

        public Boolean getConnectionEndpointRediscoveryEnabled() {
            return this.connectionEndpointRediscoveryEnabled;
        }

        public void setConnectionEndpointRediscoveryEnabled(Boolean connectionEndpointRediscoveryEnabled) {
            this.connectionEndpointRediscoveryEnabled = connectionEndpointRediscoveryEnabled;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Duration getIdleConnectionTimeout() {
            return this.idleConnectionTimeout;
        }

        public void setIdleConnectionTimeout(Duration idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
        }

        public Duration getIdleEndpointTimeout() {
            return this.idleEndpointTimeout;
        }

        public void setIdleEndpointTimeout(Duration idleEndpointTimeout) {
            this.idleEndpointTimeout = idleEndpointTimeout;
        }

        public Duration getNetworkRequestTimeout() {
            return this.networkRequestTimeout;
        }

        public void setNetworkRequestTimeout(Duration networkRequestTimeout) {
            this.networkRequestTimeout = networkRequestTimeout;
        }

        public Integer getMaxConnectionsPerEndpoint() {
            return this.maxConnectionsPerEndpoint;
        }

        public void setMaxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        }

        public Integer getMaxRequestsPerConnection() {
            return this.maxRequestsPerConnection;
        }

        public void setMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
            this.maxRequestsPerConnection = maxRequestsPerConnection;
        }
    }
}

