/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.spring.cloud.autoconfigure.kafka.AzureKafkaSpringCloudStreamConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;

class BindingServicePropertiesBeanPostProcessor
implements BeanPostProcessor {
    static final String SPRING_MAIN_SOURCES_PROPERTY = "spring.main.sources";
    private static final String KAKFA_BINDER_DEFAULT_NAME = "kafka";
    private static final String KAKFA_BINDER_TYPE = "kafka";

    BindingServicePropertiesBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof BindingServiceProperties) {
            BindingServiceProperties bindingServiceProperties = (BindingServiceProperties)bean;
            if (bindingServiceProperties.getBinders().isEmpty()) {
                BinderProperties kafkaBinderSourceProperty = new BinderProperties();
                this.configureBinderSources(kafkaBinderSourceProperty, AzureKafkaSpringCloudStreamConfiguration.AZURE_KAFKA_SPRING_CLOUD_STREAM_CONFIGURATION_CLASS);
                HashMap<String, BinderProperties> kafkaBinderPropertyMap = new HashMap<String, BinderProperties>();
                kafkaBinderPropertyMap.put("kafka", kafkaBinderSourceProperty);
                bindingServiceProperties.setBinders(kafkaBinderPropertyMap);
            } else {
                for (Map.Entry entry : bindingServiceProperties.getBinders().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || !"kafka".equalsIgnoreCase(((BinderProperties)entry.getValue()).getType()) && !"kafka".equalsIgnoreCase((String)entry.getKey())) continue;
                    this.configureBinderSources((BinderProperties)entry.getValue(), this.buildKafkaBinderSources((BinderProperties)entry.getValue()));
                }
            }
        }
        return bean;
    }

    private String buildKafkaBinderSources(BinderProperties binderProperties) {
        StringBuilder sources = new StringBuilder(AzureKafkaSpringCloudStreamConfiguration.AZURE_KAFKA_SPRING_CLOUD_STREAM_CONFIGURATION_CLASS);
        if (binderProperties.getEnvironment().get(SPRING_MAIN_SOURCES_PROPERTY) != null) {
            sources.append("," + binderProperties.getEnvironment().get(SPRING_MAIN_SOURCES_PROPERTY));
        }
        return sources.toString();
    }

    private void configureBinderSources(BinderProperties binderProperties, String sources) {
        binderProperties.getEnvironment().put(SPRING_MAIN_SOURCES_PROPERTY, sources);
    }
}

