/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aadb2c.configuration;

import com.azure.spring.cloud.autoconfigure.aadb2c.properties.AadB2cProperties;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value={"spring.cloud.azure.active-directory.b2c.enabled"}, havingValue="true")
@EnableConfigurationProperties
public class AadB2cPropertiesConfiguration {
    private final AzureGlobalProperties global;

    AadB2cPropertiesConfiguration(AzureGlobalProperties global) {
        this.global = global;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.azure.active-directory.b2c")
    @ConditionalOnMissingBean
    AadB2cProperties aadB2cProperties() {
        AadB2cProperties aadB2cProperties = new AadB2cProperties();
        aadB2cProperties.getCredential().setClientId(this.global.getCredential().getClientId());
        aadB2cProperties.getCredential().setClientSecret(this.global.getCredential().getClientSecret());
        aadB2cProperties.getProfile().setTenantId(this.global.getProfile().getTenantId());
        return aadB2cProperties;
    }
}

