/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.jms.properties;

import com.azure.spring.cloud.autoconfigure.properties.core.authentication.TokenCredentialConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.profile.AzureProfileConfigurationProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.jms.support.QosSettings;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jms.servicebus")
public class AzureServiceBusJmsProperties
implements InitializingBean,
PasswordlessProperties {
    public static final String PREFIX = "spring.jms.servicebus";
    private static final String SERVICE_BUS_SCOPE_AZURE = "https://servicebus.azure.net/.default";
    private static final String SERVICE_BUS_SCOPE_AZURE_CHINA = "https://servicebus.azure.net/.default";
    private static final String SERVICE_BUS_SCOPE_AZURE_GERMANY = "https://servicebus.azure.net/.default";
    private static final String SERVICE_BUS_SCOPE_AZURE_US_GOVERNMENT = "https://servicebus.azure.net/.default";
    private static final Map<AzureProfileOptionsProvider.CloudType, String> SERVICEBUS_SCOPE_MAP = new HashMap<AzureProfileOptionsProvider.CloudType, String>(){
        {
            this.put(AzureProfileOptionsProvider.CloudType.AZURE, "https://servicebus.azure.net/.default");
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_CHINA, "https://servicebus.azure.net/.default");
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_GERMANY, "https://servicebus.azure.net/.default");
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_US_GOVERNMENT, "https://servicebus.azure.net/.default");
        }
    };
    private AzureProfileConfigurationProperties profile = new AzureProfileConfigurationProperties();
    private String scopes;
    private TokenCredentialConfigurationProperties credential = new TokenCredentialConfigurationProperties();
    private boolean passwordlessEnabled = false;
    private boolean enabled = true;
    private String namespace;
    private String connectionString;
    private String topicClientId;
    private Duration idleTimeout = Duration.ofMinutes(2L);
    private String pricingTier;
    private final Listener listener = new Listener();
    private final PrefetchPolicy prefetchPolicy = new PrefetchPolicy();
    @NestedConfigurationProperty
    private final JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getTopicClientId() {
        return this.topicClientId;
    }

    public void setTopicClientId(String topicClientId) {
        this.topicClientId = topicClientId;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Listener getListener() {
        return this.listener;
    }

    public PrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getScopes() {
        return this.scopes == null ? this.getDefaultScopes() : this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public boolean isPasswordlessEnabled() {
        return this.passwordlessEnabled;
    }

    public void setPasswordlessEnabled(boolean passwordlessEnabled) {
        this.passwordlessEnabled = passwordlessEnabled;
    }

    public AzureProfileConfigurationProperties getProfile() {
        return this.profile;
    }

    public void setProfile(AzureProfileConfigurationProperties profile) {
        this.profile = profile;
    }

    public TokenCredentialConfigurationProperties getCredential() {
        return this.credential;
    }

    public void setCredential(TokenCredentialConfigurationProperties credential) {
        this.credential = credential;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isPasswordlessEnabled()) {
            if (!StringUtils.hasText((String)this.namespace)) {
                throw new IllegalArgumentException("Passwordless connections enabled, 'spring.jms.servicebus.namespace' should be provided.");
            }
        } else if (!StringUtils.hasText((String)this.connectionString)) {
            throw new IllegalArgumentException("'spring.jms.servicebus.connection-string' should be provided.");
        }
        if (null == this.pricingTier || !this.pricingTier.matches("(?i)premium|standard|basic")) {
            throw new IllegalArgumentException("'spring.jms.servicebus.pricing-tier' is not valid");
        }
    }

    private String getDefaultScopes() {
        return SERVICEBUS_SCOPE_MAP.getOrDefault(this.getProfile().getCloudType(), "https://servicebus.azure.net/.default");
    }

    public static class Listener {
        private Boolean replyPubSubDomain;
        private QosSettings replyQosSettings;
        private Boolean subscriptionDurable = Boolean.TRUE;
        private Boolean subscriptionShared;
        private Integer phase;

        public Boolean isReplyPubSubDomain() {
            return this.replyPubSubDomain;
        }

        public void setReplyPubSubDomain(Boolean replyPubSubDomain) {
            this.replyPubSubDomain = replyPubSubDomain;
        }

        public QosSettings getReplyQosSettings() {
            return this.replyQosSettings;
        }

        public void setReplyQosSettings(QosSettings replyQosSettings) {
            this.replyQosSettings = replyQosSettings;
        }

        public Boolean isSubscriptionDurable() {
            return this.subscriptionDurable;
        }

        public void setSubscriptionDurable(Boolean subscriptionDurable) {
            this.subscriptionDurable = subscriptionDurable;
        }

        public Boolean isSubscriptionShared() {
            return this.subscriptionShared;
        }

        public void setSubscriptionShared(Boolean subscriptionShared) {
            this.subscriptionShared = subscriptionShared;
        }

        public Integer getPhase() {
            return this.phase;
        }

        public void setPhase(Integer phase) {
            this.phase = phase;
        }
    }

    public static class PrefetchPolicy {
        private int all = 0;
        private int durableTopicPrefetch = 0;
        private int queueBrowserPrefetch = 0;
        private int queuePrefetch = 0;
        private int topicPrefetch = 0;

        public int getAll() {
            return Math.max(this.all, 0);
        }

        public void setAll(int all) {
            this.all = all;
        }

        public int getDurableTopicPrefetch() {
            return this.durableTopicPrefetch > 0 ? this.durableTopicPrefetch : this.getAll();
        }

        public void setDurableTopicPrefetch(int durableTopicPrefetch) {
            this.durableTopicPrefetch = durableTopicPrefetch;
        }

        public int getQueueBrowserPrefetch() {
            return this.queueBrowserPrefetch > 0 ? this.queueBrowserPrefetch : this.getAll();
        }

        public void setQueueBrowserPrefetch(int queueBrowserPrefetch) {
            this.queueBrowserPrefetch = queueBrowserPrefetch;
        }

        public int getQueuePrefetch() {
            return this.queuePrefetch > 0 ? this.queuePrefetch : this.getAll();
        }

        public void setQueuePrefetch(int queuePrefetch) {
            this.queuePrefetch = queuePrefetch;
        }

        public int getTopicPrefetch() {
            return this.topicPrefetch > 0 ? this.topicPrefetch : this.getAll();
        }

        public void setTopicPrefetch(int topicPrefetch) {
            this.topicPrefetch = topicPrefetch;
        }
    }
}

