/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.filter;

import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipal;
import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipalManager;
import com.azure.spring.cloud.autoconfigure.aad.implementation.graph.AadGraphClient;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthorizationServerEndpoints;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.BadJWTException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Optional;
import javax.naming.ServiceUnavailableException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class AadAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadAuthenticationFilter.class);
    private static final String CURRENT_USER_PRINCIPAL = "CURRENT_USER_PRINCIPAL";
    private final UserPrincipalManager userPrincipalManager;
    private final AadGraphClient aadGraphClient;

    public AadAuthenticationFilter(AadAuthenticationProperties aadAuthenticationProperties, AadAuthorizationServerEndpoints endpoints, ResourceRetriever resourceRetriever, RestTemplateBuilder restTemplateBuilder) {
        this(aadAuthenticationProperties, endpoints, new UserPrincipalManager(endpoints, aadAuthenticationProperties, resourceRetriever, false), restTemplateBuilder);
    }

    public AadAuthenticationFilter(AadAuthenticationProperties aadAuthenticationProperties, AadAuthorizationServerEndpoints endpoints, ResourceRetriever resourceRetriever, JWKSetCache jwkSetCache, RestTemplateBuilder restTemplateBuilder) {
        this(aadAuthenticationProperties, endpoints, new UserPrincipalManager(endpoints, aadAuthenticationProperties, resourceRetriever, false, jwkSetCache), restTemplateBuilder);
    }

    public AadAuthenticationFilter(AadAuthenticationProperties aadAuthenticationProperties, AadAuthorizationServerEndpoints endpoints, UserPrincipalManager userPrincipalManager, RestTemplateBuilder restTemplateBuilder) {
        this.userPrincipalManager = userPrincipalManager;
        this.aadGraphClient = new AadGraphClient(aadAuthenticationProperties.getCredential().getClientId(), aadAuthenticationProperties.getCredential().getClientSecret(), aadAuthenticationProperties, endpoints, restTemplateBuilder);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String aadIssuedBearerToken = Optional.of(httpServletRequest).map(r -> r.getHeader("Authorization")).map(String::trim).filter(s -> s.startsWith("Bearer ")).map(s -> s.replace("Bearer ", "")).filter(this.userPrincipalManager::isTokenIssuedByAad).orElse(null);
        if (aadIssuedBearerToken == null || this.alreadyAuthenticated()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        try {
            HttpSession httpSession = httpServletRequest.getSession();
            UserPrincipal userPrincipal = (UserPrincipal)httpSession.getAttribute(CURRENT_USER_PRINCIPAL);
            if (userPrincipal == null || !userPrincipal.getAadIssuedBearerToken().equals(aadIssuedBearerToken) || userPrincipal.getAccessTokenForGraphApi() == null) {
                userPrincipal = this.userPrincipalManager.buildUserPrincipal(aadIssuedBearerToken);
                String tenantId = userPrincipal.getClaim("tid").toString();
                String accessTokenForGraphApi = this.aadGraphClient.acquireTokenForGraphApi(aadIssuedBearerToken, tenantId).accessToken();
                userPrincipal.setAccessTokenForGraphApi(accessTokenForGraphApi);
                userPrincipal.setGroups(this.aadGraphClient.getGroups(accessTokenForGraphApi));
                httpSession.setAttribute(CURRENT_USER_PRINCIPAL, (Object)userPrincipal);
            }
            PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)userPrincipal, null, this.aadGraphClient.toGrantedAuthoritySet(userPrincipal.getGroups()));
            LOGGER.info("Request token verification success. {}", (Object)authentication);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        catch (BadJWTException ex) {
            httpServletResponse.sendError(HttpStatus.UNAUTHORIZED.value());
            return;
        }
        catch (JOSEException | BadJOSEException | MalformedURLException | ParseException ex) {
            throw new ServletException("Failed to initialize UserPrincipal.", ex);
        }
        catch (ServiceUnavailableException ex) {
            throw new ServletException("Failed to acquire graph api token.", (Throwable)ex);
        }
        catch (MsalServiceException ex) {
            if (ex.claims() != null && !ex.claims().isEmpty()) {
                throw new ServletException("Handle conditional access policy", (Throwable)ex);
            }
            throw ex;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean alreadyAuthenticated() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::isAuthenticated).orElse(false);
    }
}

