/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.keyvault.certificates;

import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.certificates.properties.AzureKeyVaultCertificateProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.common.AzureKeyVaultProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureServicePropertiesUtils;
import com.azure.spring.cloud.autoconfigure.keyvault.AzureKeyVaultConfiguration;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.keyvault.certificates.CertificateClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.certificates.CertificateClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={CertificateClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.keyvault.certificate.enabled", "spring.cloud.azure.keyvault.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefixes={"spring.cloud.azure.keyvault.certificate", "spring.cloud.azure.keyvault"}, name={"endpoint"})
@Import(value={AzureKeyVaultConfiguration.class})
public class AzureKeyVaultCertificateAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.azure.keyvault.certificate")
    AzureKeyVaultCertificateProperties azureKeyVaultCertificateProperties(AzureKeyVaultProperties azureKeyVaultProperties) {
        return AzureServicePropertiesUtils.loadServiceCommonProperties(azureKeyVaultProperties, new AzureKeyVaultCertificateProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateClient azureKeyVaultCertificateClient(CertificateClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateAsyncClient azureKeyVaultCertificateAsyncClient(CertificateClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    CertificateClientBuilder certificateClientBuilder(CertificateClientBuilderFactory factory) {
        return (CertificateClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    CertificateClientBuilderFactory certificateClientBuilderFactory(AzureKeyVaultCertificateProperties properties, ObjectProvider<AzureServiceClientBuilderCustomizer<CertificateClientBuilder>> customizers) {
        CertificateClientBuilderFactory factory = new CertificateClientBuilderFactory((CertificateClientProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_KEY_VAULT_CERTIFICATES);
        customizers.orderedStream().forEach(arg_0 -> ((CertificateClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

