/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties;

import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureAmqpConfigurationProperties;
import com.azure.spring.cloud.core.implementation.connectionstring.EventHubsConnectionString;

public abstract class AzureEventHubsCommonProperties
extends AbstractAzureAmqpConfigurationProperties {
    private String domainName;
    private String namespace;
    private String eventHubName;
    private String connectionString;
    private String customEndpointAddress;

    protected String extractFqdnFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new EventHubsConnectionString(this.connectionString).getFullyQualifiedNamespace();
    }

    protected String extractEventHubNameFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new EventHubsConnectionString(this.connectionString).getEntityPath();
    }

    public String getFullyQualifiedNamespace() {
        return this.namespace == null ? this.extractFqdnFromConnectionString() : this.buildFqdnFromNamespace();
    }

    private String buildFqdnFromNamespace() {
        if (this.namespace == null || this.domainName == null) {
            return null;
        }
        return this.namespace + "." + this.domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName == null ? this.extractEventHubNameFromConnectionString() : this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getCustomEndpointAddress() {
        return this.customEndpointAddress;
    }

    public void setCustomEndpointAddress(String customEndpointAddress) {
        this.customEndpointAddress = customEndpointAddress;
    }
}

