/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties;

import com.azure.messaging.eventhubs.LoadBalancingStrategy;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsCommonProperties;
import com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties.AzureStorageBlobProperties;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.core.PropertiesValidator;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubConsumerProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubProducerProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubsNamespaceProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventProcessorClientProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.util.CollectionUtils;

public class AzureEventHubsProperties
extends AzureEventHubsCommonProperties
implements EventHubsNamespaceProperties,
InitializingBean {
    public static final String PREFIX = "spring.cloud.azure.eventhubs";
    private static final String DEFAULT_DOMAIN_NAME = "servicebus.windows.net";
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureEventHubsProperties.class);
    private Boolean sharedConnection;
    private final Producer producer = new Producer();
    private final Consumer consumer = new Consumer();
    private final Processor processor = new Processor();

    public AzureEventHubsProperties() {
        this.setDomainName(DEFAULT_DOMAIN_NAME);
    }

    public Producer buildProducerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Producer properties = new Producer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.producer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.producer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.producer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.producer.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.producer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.producer.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        return properties;
    }

    public Consumer buildConsumerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Consumer properties = new Consumer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.consumer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.consumer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.consumer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.consumer.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.consumer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.consumer.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.consumer.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.consumer.getConsumerGroup()).to(properties::setConsumerGroup);
        return properties;
    }

    public Processor buildProcessorProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Processor properties = new Processor();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.processor, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.processor.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.processor.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.processor.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.processor.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.processor.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.processor.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.processor.getConsumerGroup()).to(properties::setConsumerGroup);
        propertyMapper.from((Object)this.processor.trackLastEnqueuedEventProperties).to(properties::setTrackLastEnqueuedEventProperties);
        propertyMapper.from(this.processor.initialPartitionEventPosition).when(c -> !CollectionUtils.isEmpty((Map)c)).to(m -> {
            Map<String, Processor.StartPosition> eventPositionMap = m.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            properties.getInitialPartitionEventPosition().putAll(eventPositionMap);
        });
        propertyMapper.from((Object)this.processor.batch.getMaxSize()).to(properties.batch::setMaxSize);
        propertyMapper.from((Object)this.processor.batch.getMaxWaitTime()).to(properties.batch::setMaxWaitTime);
        propertyMapper.from((Object)this.processor.loadBalancing.getStrategy()).to(properties.loadBalancing::setStrategy);
        propertyMapper.from((Object)this.processor.loadBalancing.getUpdateInterval()).to(properties.loadBalancing::setUpdateInterval);
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)properties, (AzureProperties)this.processor.getCheckpointStore(), (AzureProperties)properties.checkpointStore);
        BeanUtils.copyProperties((Object)this.processor.checkpointStore, (Object)properties.checkpointStore);
        return properties;
    }

    public Boolean getSharedConnection() {
        return this.sharedConnection;
    }

    public void setSharedConnection(Boolean sharedConnection) {
        this.sharedConnection = sharedConnection;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.validateNamespaceProperties();
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn(exception.getMessage());
        }
    }

    private void validateNamespaceProperties() {
        Stream.of(this.getNamespace(), this.producer.getNamespace(), this.consumer.getNamespace(), this.processor.getNamespace()).filter(Objects::nonNull).forEach(PropertiesValidator::validateNamespace);
    }

    public static class Producer
    extends AzureEventHubsCommonProperties
    implements EventHubProducerProperties {
    }

    public static class Consumer
    extends AzureEventHubsCommonProperties
    implements EventHubConsumerProperties {
        protected String consumerGroup;
        protected Integer prefetchCount;

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public Integer getPrefetchCount() {
            return this.prefetchCount;
        }

        public void setPrefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
        }
    }

    public static class Processor
    extends Consumer
    implements EventProcessorClientProperties {
        private Boolean trackLastEnqueuedEventProperties;
        private final Map<String, StartPosition> initialPartitionEventPosition = new HashMap<String, StartPosition>();
        private final EventBatch batch = new EventBatch();
        private final LoadBalancing loadBalancing = new LoadBalancing();
        private final BlobCheckpointStore checkpointStore = new BlobCheckpointStore();

        public Boolean getTrackLastEnqueuedEventProperties() {
            return this.trackLastEnqueuedEventProperties;
        }

        public void setTrackLastEnqueuedEventProperties(Boolean trackLastEnqueuedEventProperties) {
            this.trackLastEnqueuedEventProperties = trackLastEnqueuedEventProperties;
        }

        public Map<String, StartPosition> getInitialPartitionEventPosition() {
            return this.initialPartitionEventPosition;
        }

        public EventBatch getBatch() {
            return this.batch;
        }

        public LoadBalancing getLoadBalancing() {
            return this.loadBalancing;
        }

        public BlobCheckpointStore getCheckpointStore() {
            return this.checkpointStore;
        }

        public static class EventBatch
        implements EventProcessorClientProperties.EventBatch {
            private Duration maxWaitTime;
            private Integer maxSize;

            public Duration getMaxWaitTime() {
                return this.maxWaitTime;
            }

            public void setMaxWaitTime(Duration maxWaitTime) {
                this.maxWaitTime = maxWaitTime;
            }

            public Integer getMaxSize() {
                return this.maxSize;
            }

            public void setMaxSize(Integer maxSize) {
                this.maxSize = maxSize;
            }
        }

        public static class LoadBalancing
        implements EventProcessorClientProperties.LoadBalancing {
            private Duration updateInterval;
            private LoadBalancingStrategy strategy;
            private Duration partitionOwnershipExpirationInterval;

            public Duration getUpdateInterval() {
                return this.updateInterval;
            }

            public void setUpdateInterval(Duration updateInterval) {
                this.updateInterval = updateInterval;
            }

            public LoadBalancingStrategy getStrategy() {
                return this.strategy;
            }

            public void setStrategy(LoadBalancingStrategy strategy) {
                this.strategy = strategy;
            }

            public Duration getPartitionOwnershipExpirationInterval() {
                return this.partitionOwnershipExpirationInterval;
            }

            public void setPartitionOwnershipExpirationInterval(Duration partitionOwnershipExpirationInterval) {
                this.partitionOwnershipExpirationInterval = partitionOwnershipExpirationInterval;
            }
        }

        public static class BlobCheckpointStore
        extends AzureStorageBlobProperties {
            private boolean createContainerIfNotExists = false;

            public boolean isCreateContainerIfNotExists() {
                return this.createContainerIfNotExists;
            }

            public void setCreateContainerIfNotExists(Boolean createContainerIfNotExists) {
                this.createContainerIfNotExists = createContainerIfNotExists;
            }
        }

        public static class StartPosition
        implements EventProcessorClientProperties.StartPosition {
            private String offset;
            private Long sequenceNumber;
            private Instant enqueuedDateTime;
            private boolean inclusive = false;

            public String getOffset() {
                return this.offset;
            }

            public void setOffset(String offset) {
                this.offset = offset;
            }

            public Long getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Long sequenceNumber) {
                this.sequenceNumber = sequenceNumber;
            }

            public Instant getEnqueuedDateTime() {
                return this.enqueuedDateTime;
            }

            public void setEnqueuedDateTime(Instant enqueuedDateTime) {
                this.enqueuedDateTime = enqueuedDateTime;
            }

            public boolean isInclusive() {
                return this.inclusive;
            }

            public void setInclusive(boolean inclusive) {
                this.inclusive = inclusive;
            }
        }
    }
}

