/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.data.redis.lettuce;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.extensions.implementation.template.AzureAuthenticationTemplate;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import io.lettuce.core.RedisCredentials;
import java.util.Objects;

public class AzureRedisCredentials
implements RedisCredentials {
    private final AzureAuthenticationTemplate azureAuthenticationTemplate;
    private final String username;

    public AzureRedisCredentials(String username, PasswordlessProperties passwordlessProperties) {
        Objects.requireNonNull(username, "Username is required");
        Objects.requireNonNull(passwordlessProperties, "PasswordlessProperties is required");
        this.username = username;
        this.azureAuthenticationTemplate = new AzureAuthenticationTemplate();
        this.azureAuthenticationTemplate.init(passwordlessProperties.toPasswordlessProperties());
    }

    public AzureRedisCredentials(String username, PasswordlessProperties passwordlessProperties, TokenCredential tokenCredential) {
        Objects.requireNonNull(username, "Username is required");
        Objects.requireNonNull(passwordlessProperties, "PasswordlessProperties is required");
        Objects.requireNonNull(tokenCredential, "TokenCredential is required");
        this.username = username;
        this.azureAuthenticationTemplate = new AzureAuthenticationTemplate(() -> tokenCredential, null);
        this.azureAuthenticationTemplate.init(passwordlessProperties.toPasswordlessProperties());
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public char[] getPassword() {
        return this.azureAuthenticationTemplate.getTokenAsPassword().toCharArray();
    }

    public boolean hasPassword() {
        return true;
    }
}

