/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.kafka;

import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureEventHubsKafkaOAuth2AutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureKafkaSpringCloudStreamConfiguration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.StringUtils;

class BindingServicePropertiesBeanPostProcessor
implements BeanPostProcessor {
    static final String SPRING_MAIN_SOURCES_PROPERTY = "spring.main.sources";
    static final String KAFKA_OAUTH2_SPRING_MAIN_SOURCES = String.join((CharSequence)",", AzureKafkaSpringCloudStreamConfiguration.class.getName(), AzureEventHubsKafkaOAuth2AutoConfiguration.class.getName());
    private static final String DEFAULT_KAFKA_BINDER_NAME = "kafka";
    private static final String KAFKA_BINDER_TYPE = "kafka";

    BindingServicePropertiesBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof BindingServiceProperties) {
            BindingServiceProperties bindingServiceProperties = (BindingServiceProperties)bean;
            if (bindingServiceProperties.getBinders().isEmpty()) {
                HashMap<String, Object> environment = new HashMap<String, Object>();
                Map<String, Object> springMainPropertiesMap = this.getOrCreateSpringMainPropertiesMap(environment);
                this.configureSpringMainSources(springMainPropertiesMap);
                BinderProperties defaultKafkaBinder = new BinderProperties();
                defaultKafkaBinder.setEnvironment(environment);
                HashMap<String, BinderProperties> binders = new HashMap<String, BinderProperties>();
                binders.put("kafka", defaultKafkaBinder);
                bindingServiceProperties.setBinders(binders);
            } else {
                for (Map.Entry entry : bindingServiceProperties.getBinders().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    boolean isBinderTypeKafka = "kafka".equalsIgnoreCase(((BinderProperties)entry.getValue()).getType());
                    boolean isBinderNameKafka = "kafka".equalsIgnoreCase((String)entry.getKey());
                    if (!isBinderTypeKafka && !isBinderNameKafka) continue;
                    Map environment = ((BinderProperties)entry.getValue()).getEnvironment();
                    Map<String, Object> springMainPropertiesMap = this.getOrCreateSpringMainPropertiesMap(environment);
                    this.configureSpringMainSources(springMainPropertiesMap);
                }
            }
        }
        return bean;
    }

    void configureSpringMainSources(Map<String, Object> springMainPropertiesMap) {
        Object sources = KAFKA_OAUTH2_SPRING_MAIN_SOURCES;
        if (StringUtils.hasText((String)((String)springMainPropertiesMap.get("sources")))) {
            sources = (String)sources + "," + springMainPropertiesMap.get("sources");
        }
        springMainPropertiesMap.put("sources", sources);
    }

    Map<String, Object> getOrCreateSpringMainPropertiesMap(Map<String, Object> map) {
        Map spring = (Map)map.computeIfAbsent("spring", k -> new LinkedHashMap());
        return (Map)spring.computeIfAbsent("main", k -> new LinkedHashMap());
    }
}

