/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AadTrustedIssuerRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadTrustedIssuerRepository.class);
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private static final String PATH_DELIMITER = "/";
    private static final String PATH_DELIMITER_V2 = "/v2.0";
    private final Set<String> trustedIssuers = new HashSet<String>();
    private final Map<String, String> specialOidcIssuerLocationMap = new HashMap<String, String>();
    protected String tenantId;

    public AadTrustedIssuerRepository(String tenantId) {
        this.tenantId = tenantId;
        this.trustedIssuers.addAll(this.buildAadIssuers(PATH_DELIMITER));
        this.trustedIssuers.addAll(this.buildAadIssuers(PATH_DELIMITER_V2));
    }

    private List<String> buildAadIssuers(String delimiter) {
        return Stream.of(LOGIN_MICROSOFT_ONLINE_ISSUER, STS_WINDOWS_ISSUER, STS_CHINA_CLOUD_API_ISSUER).map(s -> s + this.tenantId + delimiter).collect(Collectors.toList());
    }

    public Set<String> getTrustedIssuers() {
        return Collections.unmodifiableSet(this.trustedIssuers);
    }

    public boolean addTrustedIssuer(String ... issuers) {
        return this.trustedIssuers.addAll(Arrays.asList(issuers));
    }

    public void addSpecialOidcIssuerLocationMap(String issuer, String oidcIssuerLocation) {
        this.specialOidcIssuerLocationMap.put(issuer, oidcIssuerLocation);
    }

    public boolean isTrusted(String issuer) {
        return this.trustedIssuers.contains(issuer);
    }

    public boolean hasSpecialOidcIssuerLocation(String issuer) {
        return this.specialOidcIssuerLocationMap.containsKey(issuer);
    }

    public String getSpecialOidcIssuerLocation(String issuer) {
        return this.specialOidcIssuerLocationMap.get(issuer);
    }

    protected String resolveBaseUri(String baseUri) {
        Assert.notNull((Object)baseUri, (String)"baseUri cannot be null");
        try {
            URI uri = new URI(baseUri);
            return uri.getScheme() + "://" + uri.getHost();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Resolve the base uri exception.", (Throwable)e);
            throw new RuntimeException("Resolve the base uri:'" + baseUri + "' exception.");
        }
    }
}

