/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class AzureServiceBusJmsPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    AzureServiceBusJmsPropertiesEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!environment.containsProperty("spring.jms.servicebus.pool.enabled") && !environment.containsProperty("spring.jms.cache.enabled")) {
            HashMap<String, String> azureServiceBusJms = new HashMap<String, String>();
            azureServiceBusJms.put("spring.jms.servicebus.pool.enabled", "true");
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("azureServiceBusJms", azureServiceBusJms));
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

