/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.jms.AzureServiceBusJmsCredentialSupplier;
import com.azure.spring.cloud.autoconfigure.implementation.jms.AzureServiceBusJmsPropertiesBeanPostProcessor;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsConnectionFactoryConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsContainerConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureServiceBusResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.jms.AzureServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzurePasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.ReflectionUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import jakarta.jms.ConnectionFactory;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsTemplate;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={JndiConnectionFactoryAutoConfiguration.class, AzureServiceBusResourceManagerAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.jms.servicebus.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ConnectionFactory.class, JmsConnectionFactory.class, JmsTemplate.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={ServiceBusJmsConnectionFactoryConfiguration.class, ServiceBusJmsContainerConfiguration.class})
public class ServiceBusJmsAutoConfiguration {
    @Bean
    AzureServiceBusJmsProperties serviceBusJmsProperties(AzureGlobalProperties azureGlobalProperties) {
        AzureServiceBusJmsProperties properties = new AzureServiceBusJmsProperties();
        return this.mergeAzureProperties(azureGlobalProperties, properties);
    }

    @Bean
    @ConditionalOnExpression(value="'standard'.equalsIgnoreCase('${spring.jms.servicebus.pricing-tier}')")
    AzureServiceBusJmsConnectionFactoryCustomizer amqpOpenPropertiesCustomizer(ObjectProvider<AzureServiceBusJmsCredentialSupplier> azureServiceBusJmsCredentialSupplier) {
        return factory -> {
            Map properties;
            JmsConnectionFactory jmsFactory = (JmsConnectionFactory)ReflectionUtils.getField(ServiceBusJmsConnectionFactory.class, (String)"factory", (Object)factory);
            EnumMap extensionMap = (EnumMap)ReflectionUtils.getField(JmsConnectionFactory.class, (String)"extensionMap", (Object)jmsFactory);
            if (extensionMap.containsKey(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES) && (properties = (Map)((BiFunction)extensionMap.get(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES)).apply(null, null)).containsKey("com.microsoft:is-client-provider")) {
                jmsFactory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> {
                    properties.remove("com.microsoft:is-client-provider");
                    return properties;
                });
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingProperty(prefix="spring.jms.servicebus", name={"connection-string"})
    static AzureServiceBusJmsPropertiesBeanPostProcessor azureServiceBusJmsPropertiesBeanPostProcessor(ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders) {
        return new AzureServiceBusJmsPropertiesBeanPostProcessor(connectionStringProviders);
    }

    private AzureServiceBusJmsProperties mergeAzureProperties(AzureGlobalProperties azureGlobalProperties, AzureServiceBusJmsProperties azurePasswordlessProperties) {
        AzureServiceBusJmsProperties mergedProperties = new AzureServiceBusJmsProperties();
        AzurePasswordlessPropertiesUtils.mergeAzureCommonProperties((AzureProperties)azureGlobalProperties, (PasswordlessProperties)azurePasswordlessProperties, (PasswordlessProperties)mergedProperties);
        return mergedProperties;
    }
}

