/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment;

import com.azure.core.credential.TokenCredential;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment.KeyVaultOperation;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment.KeyVaultPropertySource;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultPropertySourceProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483637;
    private static final String SKIP_CONFIGURE_REASON_FORMAT = "Skip configuring Key Vault PropertySource because %s.";
    private final Log logger;
    private final ConfigurableBootstrapContext bootstrapContext;

    public KeyVaultEnvironmentPostProcessor(DeferredLogFactory loggerFactory, ConfigurableBootstrapContext bootstrapContext) {
        this.logger = loggerFactory.getLog(this.getClass());
        this.bootstrapContext = bootstrapContext;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.isKeyVaultClientOnClasspath()) {
            this.logger.debug((Object)String.format(SKIP_CONFIGURE_REASON_FORMAT, "com.azure:azure-security-keyvault-secrets doesn't exist in classpath"));
            return;
        }
        AzureKeyVaultSecretProperties secretProperties = this.loadProperties(environment);
        if (!secretProperties.isPropertySourceEnabled()) {
            this.logger.debug((Object)String.format(SKIP_CONFIGURE_REASON_FORMAT, "spring.cloud.azure.keyvault.secret.property-source-enabled=false"));
            return;
        }
        if (secretProperties.getPropertySources().isEmpty()) {
            this.logger.debug((Object)String.format(SKIP_CONFIGURE_REASON_FORMAT, "spring.cloud.azure.keyvault.secret.property-sources is empty"));
            return;
        }
        List<AzureKeyVaultPropertySourceProperties> propertiesList = secretProperties.getPropertySources();
        this.checkDuplicatePropertySourceNames(propertiesList);
        List<KeyVaultPropertySource> keyVaultPropertySources = this.buildKeyVaultPropertySourceList(propertiesList);
        MutablePropertySources propertySources = environment.getPropertySources();
        for (int i = keyVaultPropertySources.size() - 1; i >= 0; --i) {
            KeyVaultPropertySource propertySource = keyVaultPropertySources.get(i);
            this.logger.debug((Object)("Inserting Key Vault PropertySource. name = " + propertySource.getName()));
            if (propertySources.contains("systemEnvironment")) {
                propertySources.addAfter("systemEnvironment", (PropertySource)propertySource);
                continue;
            }
            propertySources.addFirst((PropertySource)propertySource);
        }
    }

    private void checkDuplicatePropertySourceNames(List<AzureKeyVaultPropertySourceProperties> propertiesList) {
        List<String> sourceNames = propertiesList.stream().map(AzureKeyVaultPropertySourceProperties::getName).toList();
        HashSet<String> deduplicatedSourceNames = new HashSet<String>(sourceNames);
        if (propertiesList.size() != deduplicatedSourceNames.size()) {
            throw new IllegalStateException("Duplicate property source name found: " + String.valueOf(sourceNames));
        }
    }

    private List<KeyVaultPropertySource> buildKeyVaultPropertySourceList(List<AzureKeyVaultPropertySourceProperties> propertiesList) {
        ArrayList<KeyVaultPropertySource> propertySources = new ArrayList<KeyVaultPropertySource>();
        for (int i = 0; i < propertiesList.size(); ++i) {
            AzureKeyVaultPropertySourceProperties properties = propertiesList.get(i);
            if (!properties.isEnabled()) {
                this.logger.debug((Object)String.format(SKIP_CONFIGURE_REASON_FORMAT, "spring.cloud.azure.keyvault.secret.property-sources[" + i + "].enabled = false"));
                continue;
            }
            if (!StringUtils.hasText((String)properties.getEndpoint())) {
                this.logger.debug((Object)String.format(SKIP_CONFIGURE_REASON_FORMAT, "spring.cloud.azure.keyvault.secret.property-sources[" + i + "].endpoint is empty"));
                continue;
            }
            propertySources.add(this.buildKeyVaultPropertySource(properties));
        }
        return propertySources;
    }

    private KeyVaultPropertySource buildKeyVaultPropertySource(AzureKeyVaultPropertySourceProperties properties) {
        try {
            KeyVaultOperation keyVaultOperation = new KeyVaultOperation(this.buildSecretClient(properties));
            return new KeyVaultPropertySource(properties.getName(), properties.getRefreshInterval(), keyVaultOperation, properties.getSecretKeys(), properties.isCaseSensitive());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to configure KeyVault property source '" + properties.getName() + "'", exception);
        }
    }

    private SecretClient buildSecretClient(AzureKeyVaultPropertySourceProperties propertySourceProperties) {
        AzureKeyVaultSecretProperties secretProperties = this.toAzureKeyVaultSecretProperties(propertySourceProperties);
        return this.buildSecretClient(secretProperties);
    }

    private AzureKeyVaultSecretProperties toAzureKeyVaultSecretProperties(AzureKeyVaultPropertySourceProperties propertySourceProperties) {
        AzureKeyVaultSecretProperties secretProperties = new AzureKeyVaultSecretProperties();
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)propertySourceProperties, (AzureProperties)secretProperties);
        secretProperties.setEndpoint(propertySourceProperties.getEndpoint());
        secretProperties.setServiceVersion(propertySourceProperties.getServiceVersion());
        secretProperties.setChallengeResourceVerificationEnabled(propertySourceProperties.isChallengeResourceVerificationEnabled());
        return secretProperties;
    }

    SecretClient buildSecretClient(AzureKeyVaultSecretProperties secretProperties) {
        SecretClientBuilderFactory factory = new SecretClientBuilderFactory((SecretClientProperties)secretProperties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_KEY_VAULT_SECRETS);
        if (this.bootstrapContext != null && this.bootstrapContext.isRegistered(TokenCredential.class)) {
            TokenCredential registerCredential = (TokenCredential)this.bootstrapContext.get(TokenCredential.class);
            this.logger.debug((Object)(registerCredential.getClass().getSimpleName() + " is registered in bootstrap context, use it to build SecretClient."));
            factory.setTokenCredentialResolver((AzureCredentialResolver)new AzureTokenCredentialResolver(ignored -> registerCredential));
        }
        return ((SecretClientBuilder)factory.build()).buildClient();
    }

    AzureKeyVaultSecretProperties loadProperties(ConfigurableEnvironment environment) {
        int i;
        Binder binder = Binder.get((Environment)environment);
        AzureGlobalProperties globalProperties = (AzureGlobalProperties)binder.bind("spring.cloud.azure", Bindable.of(AzureGlobalProperties.class)).orElseGet(AzureGlobalProperties::new);
        AzureKeyVaultSecretProperties secretProperties = (AzureKeyVaultSecretProperties)binder.bind("spring.cloud.azure.keyvault.secret", Bindable.of(AzureKeyVaultSecretProperties.class)).orElseGet(AzureKeyVaultSecretProperties::new);
        List<AzureKeyVaultPropertySourceProperties> list = secretProperties.getPropertySources();
        for (i = 0; i < list.size(); ++i) {
            list.set(i, this.buildMergedProperties(globalProperties, list.get(i)));
        }
        for (i = 0; i < list.size(); ++i) {
            AzureKeyVaultPropertySourceProperties propertySourceProperties = list.get(i);
            if (StringUtils.hasText((String)propertySourceProperties.getName())) continue;
            propertySourceProperties.setName(this.buildPropertySourceName(i));
        }
        return secretProperties;
    }

    private AzureKeyVaultPropertySourceProperties buildMergedProperties(AzureGlobalProperties globalProperties, AzureKeyVaultPropertySourceProperties propertySourceProperties) {
        AzureKeyVaultPropertySourceProperties mergedProperties = new AzureKeyVaultPropertySourceProperties();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)globalProperties, (AzureProperties)propertySourceProperties, (AzureProperties)mergedProperties);
        mergedProperties.setEnabled(propertySourceProperties.isEnabled());
        mergedProperties.setName(propertySourceProperties.getName());
        mergedProperties.setEndpoint(propertySourceProperties.getEndpoint());
        mergedProperties.setServiceVersion(propertySourceProperties.getServiceVersion());
        mergedProperties.setCaseSensitive(propertySourceProperties.isCaseSensitive());
        mergedProperties.setSecretKeys(propertySourceProperties.getSecretKeys());
        mergedProperties.setRefreshInterval(propertySourceProperties.getRefreshInterval());
        mergedProperties.setChallengeResourceVerificationEnabled(propertySourceProperties.isChallengeResourceVerificationEnabled());
        return mergedProperties;
    }

    String buildPropertySourceName(int index) {
        return "azure-key-vault-secret-property-source-" + index;
    }

    private boolean isKeyVaultClientOnClasspath() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.secrets.SecretClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }

    public int getOrder() {
        return -2147483637;
    }
}

