/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.data.redis.lettuce;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.extensions.implementation.template.AzureAuthenticationTemplate;
import com.azure.spring.cloud.autoconfigure.implementation.util.SpringPasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import io.lettuce.core.RedisCredentials;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AzureRedisCredentials
implements RedisCredentials {
    public static final Logger LOGGER = LoggerFactory.getLogger(AzureRedisCredentials.class);
    private final AzureAuthenticationTemplate azureAuthenticationTemplate;
    private final String username;

    public AzureRedisCredentials(String username, PasswordlessProperties passwordlessProperties) {
        Objects.requireNonNull(passwordlessProperties, "PasswordlessProperties is required.");
        this.azureAuthenticationTemplate = new AzureAuthenticationTemplate();
        Properties properties = passwordlessProperties.toPasswordlessProperties();
        SpringPasswordlessPropertiesUtils.enhancePasswordlessProperties("spring.data.redis.azure", passwordlessProperties, properties);
        this.azureAuthenticationTemplate.init(properties);
        this.username = AzureRedisCredentials.resolveUsername(this.azureAuthenticationTemplate, username);
    }

    public AzureRedisCredentials(String username, PasswordlessProperties passwordlessProperties, TokenCredential tokenCredential) {
        Objects.requireNonNull(passwordlessProperties, "PasswordlessProperties is required");
        Objects.requireNonNull(tokenCredential, "TokenCredential is required");
        this.azureAuthenticationTemplate = new AzureAuthenticationTemplate(() -> tokenCredential, null);
        this.azureAuthenticationTemplate.init(passwordlessProperties.toPasswordlessProperties());
        this.username = AzureRedisCredentials.resolveUsername(this.azureAuthenticationTemplate, username);
    }

    private static String resolveUsername(AzureAuthenticationTemplate authenticationTemplate, String username) {
        if (StringUtils.hasText((String)username)) {
            LOGGER.debug("Username is set to {}, skipping retrieving it from the JWT", (Object)username);
            return username;
        }
        try {
            String tokenAsPassword = authenticationTemplate.getTokenAsPassword();
            JWT jwt = JWTParser.parse((String)tokenAsPassword);
            String oid = jwt.getJWTClaimsSet().getClaim("oid").toString();
            LOGGER.debug("Username is resolved to {}", (Object)oid);
            return oid;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse the token, can't get the username from the token", e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public char[] getPassword() {
        return this.azureAuthenticationTemplate.getTokenAsPassword().toCharArray();
    }

    public boolean hasPassword() {
        return true;
    }
}

