/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.implementation.util.SpringPasswordlessPropertiesUtils;
import com.azure.spring.cloud.autoconfigure.jms.AzureServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ServiceBusJmsConnectionFactoryFactory {
    private final AzureServiceBusJmsProperties properties;
    private final List<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers;
    private final TokenCredentialProvider tokenCredentialProvider;

    ServiceBusJmsConnectionFactoryFactory(AzureServiceBusJmsProperties properties, List<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
        List<AzureServiceBusJmsConnectionFactoryCustomizer> list = this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
        if (properties.isPasswordlessEnabled()) {
            Properties passwordlessProperties = properties.toPasswordlessProperties();
            SpringPasswordlessPropertiesUtils.enhancePasswordlessProperties("spring.jms.servicebus", (PasswordlessProperties)properties, passwordlessProperties);
            this.tokenCredentialProvider = TokenCredentialProvider.createDefault((TokenCredentialProviderOptions)new TokenCredentialProviderOptions(passwordlessProperties));
        } else {
            this.tokenCredentialProvider = null;
        }
    }

    <T extends ServiceBusJmsConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        T factory = this.createConnectionFactoryInstance(factoryClass);
        this.setClientId(factory);
        this.setPrefetchPolicy(factory);
        this.customize((ServiceBusJmsConnectionFactory)factory);
        return factory;
    }

    private <T extends ServiceBusJmsConnectionFactory> void setClientId(T factory) {
        if (StringUtils.hasText((String)this.properties.getTopicClientId())) {
            factory.setClientId(this.properties.getTopicClientId());
        }
    }

    private <T extends ServiceBusJmsConnectionFactory> void setPrefetchPolicy(T factory) {
        AzureServiceBusJmsProperties.PrefetchPolicy prefetchProperties = this.properties.getPrefetchPolicy();
        factory.getSettings().getConfigurationOptions().put("jms.prefetchPolicy.durableTopicPrefetch", String.valueOf(prefetchProperties.getDurableTopicPrefetch()));
        factory.getSettings().getConfigurationOptions().put("jms.prefetchPolicy.queueBrowserPrefetch", String.valueOf(prefetchProperties.getQueueBrowserPrefetch()));
        factory.getSettings().getConfigurationOptions().put("jms.prefetchPolicy.queuePrefetch", String.valueOf(prefetchProperties.getQueuePrefetch()));
        factory.getSettings().getConfigurationOptions().put("jms.prefetchPolicy.topicPrefetch", String.valueOf(prefetchProperties.getTopicPrefetch()));
    }

    private <T extends ServiceBusJmsConnectionFactory> T createConnectionFactoryInstance(Class<T> factoryClass) {
        try {
            ServiceBusJmsConnectionFactory factory;
            if (this.properties.isPasswordlessEnabled()) {
                String hostName = this.properties.getNamespace() + "." + this.properties.getProfile().getEnvironment().getServiceBusDomainName();
                TokenCredential tokenCredential = (TokenCredential)this.tokenCredentialProvider.get();
                factory = (ServiceBusJmsConnectionFactory)factoryClass.getConstructor(TokenCredential.class, String.class, ServiceBusJmsConnectionFactorySettings.class).newInstance(tokenCredential, hostName, new ServiceBusJmsConnectionFactorySettings());
            } else {
                factory = (ServiceBusJmsConnectionFactory)factoryClass.getConstructor(String.class, ServiceBusJmsConnectionFactorySettings.class).newInstance(this.properties.getConnectionString(), new ServiceBusJmsConnectionFactorySettings());
            }
            return (T)factory;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to create JmsConnectionFactory", ex);
        }
    }

    private void customize(ServiceBusJmsConnectionFactory connectionFactory) {
        for (AzureServiceBusJmsConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            factoryCustomizer.customize(connectionFactory);
        }
    }
}

