/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.constants.Constants;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties.AadAuthorizationServerEndpoints;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties.AuthorizationClientProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;

public class AadClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadClientRegistrationRepository.class);
    public static final String AZURE_CLIENT_REGISTRATION_ID = "azure";
    private final Set<String> azureClientAccessTokenScopes;
    private final Map<String, ClientRegistration> allClients;

    public AadClientRegistrationRepository(AadAuthenticationProperties properties) {
        Set<String> accessTokenScopes = this.azureClientAccessTokenScopes(properties);
        Set<String> delegatedScopes = this.delegatedClientsAccessTokenScopes(properties);
        HashSet<String> authorizationCodeScopes = new HashSet<String>();
        authorizationCodeScopes.addAll(accessTokenScopes);
        authorizationCodeScopes.addAll(delegatedScopes);
        if (AadClientRegistrationRepository.resourceServerCount(accessTokenScopes) == 0 && AadClientRegistrationRepository.resourceServerCount(authorizationCodeScopes) > 1) {
            String newScope = properties.getProfile().getEnvironment().getMicrosoftGraphEndpoint() + "User.Read";
            accessTokenScopes.add(newScope);
            authorizationCodeScopes.add(newScope);
        }
        this.azureClientAccessTokenScopes = accessTokenScopes;
        this.allClients = properties.getAuthorizationClients().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toClientRegistration((String)entry.getKey(), ((AuthorizationClientProperties)entry.getValue()).getAuthorizationGrantType(), ((AuthorizationClientProperties)entry.getValue()).getScopes(), ((AuthorizationClientProperties)entry.getValue()).getClientAuthenticationMethod(), properties)));
        ClientAuthenticationMethod azureClientAuthMethod = this.getAzureDefaultClientAuthenticationMethod();
        ClientRegistration azureClient = this.toClientRegistration(AZURE_CLIENT_REGISTRATION_ID, AuthorizationGrantType.AUTHORIZATION_CODE, authorizationCodeScopes, azureClientAuthMethod, properties);
        this.allClients.put(AZURE_CLIENT_REGISTRATION_ID, azureClient);
    }

    private ClientAuthenticationMethod getAzureDefaultClientAuthenticationMethod() {
        if (this.allClients.containsKey(AZURE_CLIENT_REGISTRATION_ID)) {
            return this.allClients.get(AZURE_CLIENT_REGISTRATION_ID).getClientAuthenticationMethod();
        }
        return ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
    }

    public Set<String> getAzureClientAccessTokenScopes() {
        return this.azureClientAccessTokenScopes;
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.allClients.get(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.allClients.values().stream().filter(client -> AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)client.getAuthorizationGrantType())).iterator();
    }

    private Set<String> azureClientAccessTokenScopes(AadAuthenticationProperties properties) {
        Set result = Optional.of(properties).map(AadAuthenticationProperties::getAuthorizationClients).map(clients -> (AuthorizationClientProperties)clients.get(AZURE_CLIENT_REGISTRATION_ID)).map(AuthorizationClientProperties::getScopes).map(HashSet::new).orElseGet(HashSet::new);
        result.add("openid");
        result.add("profile");
        result.add("offline_access");
        if (properties.isAllowedGroupNamesConfigured()) {
            result.add(properties.getProfile().getEnvironment().getMicrosoftGraphEndpoint() + "Directory.Read.All");
        } else if (properties.isAllowedGroupIdsConfigured()) {
            result.add(properties.getProfile().getEnvironment().getMicrosoftGraphEndpoint() + "User.Read");
        }
        return result;
    }

    private Set<String> delegatedClientsAccessTokenScopes(AadAuthenticationProperties properties) {
        return properties.getAuthorizationClients().values().stream().filter(p -> Constants.AZURE_DELEGATED.getValue().equals(p.getAuthorizationGrantType().getValue())).flatMap(p -> p.getScopes().stream()).collect(Collectors.toSet());
    }

    private ClientRegistration toClientRegistration(String registrationId, AuthorizationGrantType authorizationGrantType, Collection<String> scopes, ClientAuthenticationMethod clientAuthenticationMethod, AadAuthenticationProperties properties) {
        AadAuthorizationServerEndpoints endpoints = new AadAuthorizationServerEndpoints(properties.getProfile().getEnvironment().getActiveDirectoryEndpoint(), properties.getProfile().getTenantId());
        if (Constants.ON_BEHALF_OF.equals((Object)authorizationGrantType)) {
            authorizationGrantType = AuthorizationGrantType.JWT_BEARER;
            LOGGER.warn("The grant type 'on_behalf_of' is an alias, it will be replaced with 'urn:ietf:params:oauth:grant-type:jwt-bearer' for client {}.", (Object)registrationId);
        }
        return ClientRegistration.withRegistrationId((String)registrationId).clientName(registrationId).authorizationGrantType(authorizationGrantType).scope(scopes).redirectUri(properties.getRedirectUriTemplate()).userNameAttributeName(properties.getUserNameAttribute()).clientId(properties.getCredential().getClientId()).clientSecret(properties.getCredential().getClientSecret()).clientAuthenticationMethod(clientAuthenticationMethod).authorizationUri(endpoints.getAuthorizationEndpoint()).tokenUri(endpoints.getTokenEndpoint()).jwkSetUri(endpoints.getJwkSetEndpoint()).providerConfigurationMetadata(this.providerConfigurationMetadata(endpoints)).build();
    }

    private Map<String, Object> providerConfigurationMetadata(AadAuthorizationServerEndpoints endpoints) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String endSessionEndpoint = endpoints.getEndSessionEndpoint();
        result.put("end_session_endpoint", endSessionEndpoint);
        return result;
    }

    public static int resourceServerCount(Set<String> scopes) {
        return (int)scopes.stream().filter(scope -> scope.contains("/")).map(scope -> scope.substring(0, scope.lastIndexOf(47))).distinct().count();
    }
}

