/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.kafka;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AbstractKafkaPropertiesBeanPostProcessor;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;

class KafkaBinderConfigurationPropertiesBeanPostProcessor
extends AbstractKafkaPropertiesBeanPostProcessor<KafkaBinderConfigurationProperties> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaBinderConfigurationPropertiesBeanPostProcessor.class);

    KafkaBinderConfigurationPropertiesBeanPostProcessor(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @Override
    protected Map<String, Object> getMergedProducerProperties(KafkaBinderConfigurationProperties properties) {
        return this.mergeNonAdminProperties(properties.mergedProducerConfiguration(), properties.getConfiguration());
    }

    @Override
    protected Map<String, String> getRawProducerProperties(KafkaBinderConfigurationProperties properties) {
        return properties.getProducerProperties();
    }

    @Override
    protected Map<String, Object> getMergedConsumerProperties(KafkaBinderConfigurationProperties properties) {
        return this.mergeNonAdminProperties(properties.mergedConsumerConfiguration(), properties.getConfiguration());
    }

    @Override
    protected Map<String, String> getRawConsumerProperties(KafkaBinderConfigurationProperties properties) {
        return properties.getConsumerProperties();
    }

    @Override
    protected Map<String, Object> getMergedAdminProperties(KafkaBinderConfigurationProperties properties) {
        return this.mergeAdminProperties(properties);
    }

    @Override
    protected Map<String, String> getRawAdminProperties(KafkaBinderConfigurationProperties properties) {
        return properties.getConfiguration();
    }

    @Override
    protected boolean needsPostProcess(Object bean) {
        return bean instanceof KafkaBinderConfigurationProperties;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private Map<String, Object> mergeNonAdminProperties(Map<String, Object> mergedPropertiesWithoutDefault, Map<String, String> defaultProperties) {
        HashMap<String, Object> merged = new HashMap<String, Object>(defaultProperties);
        merged.putAll(mergedPropertiesWithoutDefault);
        return merged;
    }

    private Map<String, Object> mergeAdminProperties(KafkaBinderConfigurationProperties properties) {
        Map adminProperties = properties.getKafkaProperties().buildAdminProperties();
        KafkaTopicProvisioner.normalalizeBootPropsWithBinder((Map)adminProperties, (KafkaProperties)properties.getKafkaProperties(), (KafkaBinderConfigurationProperties)properties);
        AzureKafkaPropertiesUtils.AzureKafkaPasswordlessPropertiesMapping.getPropertyKeys().forEach(k -> PROPERTY_MAPPER.from((Object)((String)properties.getConfiguration().get(k))).to(v -> adminProperties.put(k, v)));
        return adminProperties;
    }
}

