/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadResourceServerProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

public class AadJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadJwtGrantedAuthoritiesConverter.class);
    private final Map<String, String> claimToAuthorityPrefixMap;

    public AadJwtGrantedAuthoritiesConverter() {
        this.claimToAuthorityPrefixMap = AadResourceServerProperties.DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP;
    }

    public AadJwtGrantedAuthoritiesConverter(Map<String, String> claimToAuthorityPrefixMap) {
        this.claimToAuthorityPrefixMap = claimToAuthorityPrefixMap;
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        this.claimToAuthorityPrefixMap.forEach((authoritiesClaimName, authorityPrefix) -> Optional.of(authoritiesClaimName).map(arg_0 -> ((Jwt)jwt).getClaim(arg_0)).map(this::getClaimValueAsCollection).map(Collection::stream).orElseGet(Stream::empty).map(authority -> authorityPrefix + authority).map(SimpleGrantedAuthority::new).forEach(grantedAuthorities::add));
        LOGGER.debug("User {}'s authorities created from jwt token: {}.", (Object)jwt.getSubject(), grantedAuthorities);
        return grantedAuthorities;
    }

    private Collection<?> getClaimValueAsCollection(Object claimValue) {
        if (claimValue instanceof String) {
            return Arrays.asList(((String)claimValue).split(" "));
        }
        if (claimValue instanceof Collection) {
            return (Collection)claimValue;
        }
        return Collections.emptyList();
    }
}

