/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration;

import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jose.RestOperationsResourceRetriever;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt.AadIssuerJwsKeySelector;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt.AadJwtIssuerValidator;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt.AadTrustedIssuerRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.AadB2cOAuth2ClientConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.AadB2cPropertiesConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.jwt.AadB2cTrustedIssuerRepository;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"spring.cloud.azure.active-directory.b2c.enabled"}, havingValue="true")
@ConditionalOnClass(value={BearerTokenAuthenticationToken.class})
@Import(value={AadB2cPropertiesConfiguration.class, AadB2cOAuth2ClientConfiguration.class})
public class AadB2cResourceServerAutoConfiguration {
    private final AadB2cProperties properties;
    private final RestTemplateBuilder restTemplateBuilder;

    AadB2cResourceServerAutoConfiguration(AadB2cProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this.properties = properties;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    AadTrustedIssuerRepository trustedIssuerRepository() {
        return new AadB2cTrustedIssuerRepository(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRetriever.class})
    ResourceRetriever jwtResourceRetriever() {
        return new RestOperationsResourceRetriever(this.restTemplateBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    JWTClaimsSetAwareJWSKeySelector<SecurityContext> aadIssuerJwsKeySelector(AadTrustedIssuerRepository aadTrustedIssuerRepository, ResourceRetriever resourceRetriever) {
        return new AadIssuerJwsKeySelector(this.restTemplateBuilder, aadTrustedIssuerRepository, resourceRetriever);
    }

    @Bean
    @ConditionalOnMissingBean
    JWTProcessor<SecurityContext> jwtProcessor(JWTClaimsSetAwareJWSKeySelector<SecurityContext> keySelector) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetAwareJWSKeySelector(keySelector);
        return jwtProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    JwtDecoder jwtDecoder(JWTProcessor<SecurityContext> jwtProcessor, AadTrustedIssuerRepository trustedIssuerRepository) {
        NimbusJwtDecoder decoder = new NimbusJwtDecoder(jwtProcessor);
        ArrayList<Object> validators = new ArrayList<Object>();
        ArrayList<String> validAudiences = new ArrayList<String>();
        if (StringUtils.hasText((String)this.properties.getAppIdUri())) {
            validAudiences.add(this.properties.getAppIdUri());
        }
        if (StringUtils.hasText((String)this.properties.getCredential().getClientId())) {
            validAudiences.add(this.properties.getCredential().getClientId());
        }
        if (!validAudiences.isEmpty()) {
            validators.add(new JwtClaimValidator("aud", validAudiences::containsAll));
        }
        validators.add(new AadJwtIssuerValidator(trustedIssuerRepository));
        validators.add(new JwtTimestampValidator());
        decoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(validators));
        return decoder;
    }
}

