/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.conditions;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadApplicationType;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

abstract class AbstractApplicationTypeCondition
extends SpringBootCondition {
    AbstractApplicationTypeCondition() {
    }

    abstract boolean isTargetApplicationType(AadApplicationType var1);

    private boolean isNotTargetApplicationType(AadApplicationType applicationType) {
        return !this.isTargetApplicationType(applicationType);
    }

    abstract String getConditionTitle();

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)this.getConditionTitle(), (Object[])new Object[0]);
        AadAuthenticationProperties properties = (AadAuthenticationProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory", AadAuthenticationProperties.class).orElse(null);
        if (properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("Azure AD authentication properties"));
        }
        AadApplicationType applicationType = Optional.ofNullable(properties.getApplicationType()).orElseGet(AadApplicationType::inferApplicationTypeByDependencies);
        if (this.isNotTargetApplicationType(applicationType)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("spring.cloud.azure.active-directory.application-type=" + applicationType));
        }
        return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("spring.cloud.azure.active-directory.application-type=" + applicationType)));
    }
}

