/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.constants.Constants;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.GraphClient;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.GroupInformation;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AadOAuth2UserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadOAuth2UserService.class);
    private final List<String> allowedGroupNames;
    private final Set<String> allowedGroupIds;
    private final GraphClient graphClient;
    private static final String DEFAULT_OIDC_USER = "defaultOidcUser";
    private static final String ROLES = "roles";

    public AadOAuth2UserService(AadAuthenticationProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this(properties, new GraphClient(properties, restTemplateBuilder));
    }

    public AadOAuth2UserService(AadAuthenticationProperties properties, GraphClient graphClient, RestTemplateBuilder restTemplateBuilder) {
        this(properties, graphClient);
    }

    private AadOAuth2UserService(AadAuthenticationProperties properties, GraphClient graphClient) {
        this.allowedGroupNames = Optional.ofNullable(properties).map(AadAuthenticationProperties::getUserGroup).map(AadAuthenticationProperties.UserGroupProperties::getAllowedGroupNames).orElseGet(Collections::emptyList);
        this.allowedGroupIds = Optional.ofNullable(properties).map(AadAuthenticationProperties::getUserGroup).map(AadAuthenticationProperties.UserGroupProperties::getAllowedGroupIds).orElseGet(Collections::emptySet);
        this.graphClient = graphClient;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession session = attr.getRequest().getSession(true);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            LOGGER.debug("User {}'s authorities saved from session: {}.", (Object)authentication.getName(), (Object)authentication.getAuthorities());
            return (DefaultOidcUser)session.getAttribute(DEFAULT_OIDC_USER);
        }
        DefaultOidcUser defaultOidcUser = this.getUser(userRequest);
        session.setAttribute(DEFAULT_OIDC_USER, (Object)defaultOidcUser);
        return defaultOidcUser;
    }

    DefaultOidcUser getUser(OidcUserRequest userRequest) {
        Set<SimpleGrantedAuthority> authorities = this.buildAuthorities(userRequest);
        String nameAttributeKey = this.getNameAttributeKey(userRequest);
        OidcIdToken idToken = userRequest.getIdToken();
        DefaultOidcUser defaultOidcUser = new DefaultOidcUser(authorities, idToken, nameAttributeKey);
        return defaultOidcUser;
    }

    private String getNameAttributeKey(OidcUserRequest userRequest) {
        return Optional.of(userRequest).map(u -> u.getClientRegistration()).map(u -> u.getProviderDetails()).map(u -> u.getUserInfoEndpoint()).map(u -> u.getUserNameAttributeName()).filter(StringUtils::hasText).orElse("name");
    }

    private Set<SimpleGrantedAuthority> buildAuthorities(OidcUserRequest userRequest) {
        HashSet<String> authorityStrings = new HashSet<String>();
        authorityStrings.addAll(this.extractRolesFromIdToken(userRequest.getIdToken()));
        authorityStrings.addAll(this.extractGroupRolesFromAccessToken(userRequest.getAccessToken()));
        Set<SimpleGrantedAuthority> authorities = authorityStrings.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        if (authorities.isEmpty()) {
            authorities = Constants.DEFAULT_AUTHORITY_SET;
        }
        return authorities;
    }

    Set<String> extractRolesFromIdToken(OidcIdToken idToken) {
        return Optional.ofNullable(idToken).map(token -> (Collection)token.getClaim(ROLES)).filter(obj -> obj instanceof List).map(Collection::stream).orElseGet(Stream::empty).filter(s -> StringUtils.hasText((String)s.toString())).map(role -> "APPROLE_" + role).collect(Collectors.toSet());
    }

    Set<String> extractGroupRolesFromAccessToken(OAuth2AccessToken accessToken) {
        if (this.allowedGroupNames.isEmpty() && this.allowedGroupIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet roles = new HashSet();
        GroupInformation groupInformation = this.getGroupInformation(accessToken);
        if (!this.allowedGroupNames.isEmpty()) {
            Optional.of(groupInformation).map(GroupInformation::getGroupsNames).map(Collection::stream).orElseGet(Stream::empty).filter(this.allowedGroupNames::contains).forEach(roles::add);
        }
        if (!this.allowedGroupIds.isEmpty()) {
            Optional.of(groupInformation).map(GroupInformation::getGroupsIds).map(Collection::stream).orElseGet(Stream::empty).filter(this::isAllowedGroupId).forEach(roles::add);
        }
        return roles.stream().map(roleStr -> "ROLE_" + roleStr).collect(Collectors.toSet());
    }

    private boolean isAllowedGroupId(String groupId) {
        if (this.allowedGroupIds.size() == 1 && this.allowedGroupIds.contains("all")) {
            return true;
        }
        return this.allowedGroupIds.contains(groupId);
    }

    private GroupInformation getGroupInformation(OAuth2AccessToken accessToken) {
        return Optional.of(accessToken).map(AbstractOAuth2Token::getTokenValue).map(this.graphClient::getGroupInformation).orElseGet(GroupInformation::new);
    }
}

