/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.context;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Import(value={Registrar.class})
public class AzureGlobalPropertiesAutoConfiguration {

    static class AzureGlobalPropertiesBeanRegistrationExcludeFilter
    implements BeanRegistrationExcludeFilter {
        AzureGlobalPropertiesBeanRegistrationExcludeFilter() {
        }

        public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
            return "springCloudAzureGlobalProperties".equals(registeredBean.getBeanName());
        }
    }

    static class Registrar
    implements EnvironmentAware,
    ImportBeanDefinitionRegistrar {
        private Environment environment;

        Registrar() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition("springCloudAzureGlobalProperties")) {
                registry.registerBeanDefinition("springCloudAzureGlobalProperties", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(AzureGlobalProperties.class, () -> (AzureGlobalProperties)Binder.get((Environment)this.environment).bindOrCreate("spring.cloud.azure", AzureGlobalProperties.class)).getBeanDefinition());
            }
        }
    }
}

