/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.resourcemanager;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureServiceResourceManagerConfigurationBase;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.EventHubsResourceMetadata;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.connectionstring.EventHubsArmConnectionStringProvider;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.DefaultEventHubsProvisioner;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.EventHubsProvisioner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs", value={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={AzureResourceManager.class})
@ConditionalOnClass(value={EventHubsProvisioner.class})
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@EnableConfigurationProperties(value={EventHubsResourceMetadata.class})
public class AzureEventHubsResourceManagerAutoConfiguration
extends AzureServiceResourceManagerConfigurationBase {
    private final EventHubsResourceMetadata resourceMetadata;

    AzureEventHubsResourceManagerAutoConfiguration(AzureResourceManager azureResourceManager, EventHubsResourceMetadata resourceMetadata) {
        super(azureResourceManager);
        this.resourceMetadata = resourceMetadata;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs", value={"namespace"})
    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.eventhubs", value={"connection-string"})
    @Order
    EventHubsArmConnectionStringProvider eventHubsArmConnectionStringProvider() {
        return new EventHubsArmConnectionStringProvider(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata, this.resourceMetadata.getName());
    }

    @Bean
    @ConditionalOnMissingBean
    EventHubsProvisioner eventHubsProvisioner() {
        return new DefaultEventHubsProvisioner(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata);
    }
}

