/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad;

import com.azure.spring.cloud.autoconfigure.aad.implementation.jwt.AadJwtGrantedAuthoritiesConverter;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadResourceServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.StringUtils;

public class AadResourceServerHttpSecurityConfigurer
extends AbstractHttpConfigurer<AadResourceServerHttpSecurityConfigurer, HttpSecurity> {
    private AadResourceServerProperties properties;

    public void init(HttpSecurity builder) throws Exception {
        super.init((SecurityBuilder)builder);
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        this.properties = (AadResourceServerProperties)context.getBean(AadResourceServerProperties.class);
        builder.oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.jwtAuthenticationConverter());
    }

    public static AadResourceServerHttpSecurityConfigurer aadResourceServer() {
        return new AadResourceServerHttpSecurityConfigurer();
    }

    private Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        if (StringUtils.hasText((String)this.properties.getPrincipalClaimName())) {
            converter.setPrincipalClaimName(this.properties.getPrincipalClaimName());
        }
        converter.setJwtGrantedAuthoritiesConverter((Converter)new AadJwtGrantedAuthoritiesConverter(this.properties.getClaimToAuthorityPrefixMap()));
        return converter;
    }
}

