/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aadb2c;

import com.azure.spring.cloud.autoconfigure.aadb2c.properties.AadB2cProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AadB2cAuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private static final String REQUEST_BASE_URI = "/oauth2/authorization";
    private static final String REGISTRATION_ID_NAME = "registrationId";
    private static final String PARAMETER_X_CLIENT_SKU = "x-client-SKU";
    private static final String AAD_B2C_USER_AGENT = "spring-boot-starter";
    private static final String MATCHER_PATTERN = String.format("%s/{%s}", "/oauth2/authorization", "registrationId");
    private static final AntPathRequestMatcher REQUEST_MATCHER = new AntPathRequestMatcher(MATCHER_PATTERN);
    private final OAuth2AuthorizationRequestResolver delegateResolver;
    private final String passwordResetUserFlow;
    private final AadB2cProperties properties;

    public AadB2cAuthorizationRequestResolver(ClientRegistrationRepository repository, AadB2cProperties properties) {
        this(properties, (OAuth2AuthorizationRequestResolver)new DefaultOAuth2AuthorizationRequestResolver(repository, REQUEST_BASE_URI));
    }

    public AadB2cAuthorizationRequestResolver(AadB2cProperties properties, OAuth2AuthorizationRequestResolver delegateResolver) {
        this.properties = properties;
        this.passwordResetUserFlow = this.properties.getPasswordReset();
        this.delegateResolver = delegateResolver;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.resolve(request, this.getRegistrationId(request));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String registrationId) {
        if (StringUtils.hasText((String)this.passwordResetUserFlow) && this.isForgotPasswordAuthorizationRequest(request)) {
            OAuth2AuthorizationRequest authRequest = this.delegateResolver.resolve(request, this.passwordResetUserFlow);
            return this.getB2cAuthorizationRequest(authRequest, this.passwordResetUserFlow);
        }
        if (StringUtils.hasText((String)registrationId) && REQUEST_MATCHER.matches(request)) {
            return this.getB2cAuthorizationRequest(this.delegateResolver.resolve(request), registrationId);
        }
        return null;
    }

    private OAuth2AuthorizationRequest getB2cAuthorizationRequest(OAuth2AuthorizationRequest request, String userFlow) {
        Assert.hasText((String)userFlow, (String)"User flow should contain text.");
        if (request == null) {
            return null;
        }
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        Optional.ofNullable(this.properties).map(AadB2cProperties::getAuthenticateAdditionalParameters).ifPresent(additionalParameters::putAll);
        additionalParameters.put("p", userFlow);
        additionalParameters.put(PARAMETER_X_CLIENT_SKU, AAD_B2C_USER_AGENT);
        additionalParameters.putAll(request.getAdditionalParameters());
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)request).additionalParameters(additionalParameters).build();
    }

    private String getRegistrationId(HttpServletRequest request) {
        if (REQUEST_MATCHER.matches(request)) {
            return (String)REQUEST_MATCHER.matcher(request).getVariables().get(REGISTRATION_ID_NAME);
        }
        return null;
    }

    private boolean isForgotPasswordAuthorizationRequest(HttpServletRequest request) {
        String error = request.getParameter("error");
        String description = request.getParameter("error_description");
        if ("access_denied".equals(error)) {
            Assert.hasText((String)description, (String)"description should contain text.");
            return description.startsWith("AADB2C90118:");
        }
        return false;
    }
}

