/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.cloudfoundry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

enum AzureCfService {
    SERVICEBUS("servicebus", "azure-servicebus", AzureCfService.getImmutableMap("connectionString", "connection-string")),
    EVENTHUBS("eventhubs", "azure-eventhubs", AzureCfService.getImmutableMap("connectionString", "connection-string")),
    STORAGE("storage.blob", "azure-storage", AzureCfService.getImmutableMap("storageAccountName", "account-name", "accessKey", "account-key")),
    EVENTHUBS_PROCESSOR("eventhubs.processor.checkpoint-store", "azure-storage", AzureCfService.getImmutableMap("storageAccountName", "account-name", "accessKey", "account-key")),
    REDIS("spring.data.redis", "azure-rediscache", AzureCfService.getImmutableMap("host", "host", "password", "password", "port", "port"), false);

    private static final String SPRING_CLOUD_AZURE_PROPERTY_PREFIX = "spring.cloud.azure.";
    private final String cfServiceName;
    private final String azureServiceName;
    private final Map<String, String> cfToAzureProperties;
    private final boolean isAzureProperty;

    private AzureCfService(String azureServiceName, String cfServiceName, Map<String, String> cfToAzureProperties) {
        this(azureServiceName, cfServiceName, cfToAzureProperties, true);
    }

    private AzureCfService(String azureServiceName, String cfServiceName, Map<String, String> cfToAzureProperties, boolean isAzureProperty) {
        this.cfServiceName = cfServiceName;
        this.azureServiceName = azureServiceName;
        this.isAzureProperty = isAzureProperty;
        this.cfToAzureProperties = this.buildCfToAzureProperties(cfToAzureProperties);
    }

    public String getCfServiceName() {
        return this.cfServiceName;
    }

    public Map<String, String> getCfToAzureProperties() {
        return this.cfToAzureProperties;
    }

    public String getAzureServiceName() {
        return this.azureServiceName;
    }

    private Map<String, String> buildCfToAzureProperties(Map<String, String> cfToAzureProperties) {
        return cfToAzureProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getPropertyPrefix() + (String)e.getValue()));
    }

    private String getPropertyPrefix() {
        if (this.isAzureProperty) {
            return SPRING_CLOUD_AZURE_PROPERTY_PREFIX + this.azureServiceName + ".";
        }
        return this.azureServiceName + ".";
    }

    private static Map<String, String> getImmutableMap(String ... values) {
        int pairs = values.length / 2;
        HashMap<String, String> output = new HashMap<String, String>(pairs);
        for (int i = 0; i < pairs; ++i) {
            String key = values[2 * i];
            String value = values[2 * i + 1];
            output.put(key, value);
        }
        return Collections.unmodifiableMap(output);
    }
}

