/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.core.credential.TokenCredential;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureKafkaConfigurationUtils;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.passwordless.AzurePasswordlessProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaConsumerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhubs.kafka.enabled"}, havingValue="true", matchIfMissing=true)
public class AzureEventHubsKafkaOAuth2AutoConfiguration {
    private final KafkaProperties kafkaProperties;
    private final AzureTokenCredentialResolver tokenCredentialResolver;
    private final AzureGlobalProperties azureGlobalProperties;
    private final TokenCredential defaultTokenCredential;

    AzureEventHubsKafkaOAuth2AutoConfiguration(KafkaProperties kafkaProperties, AzureTokenCredentialResolver resolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultTokenCredential, AzureGlobalProperties azureGlobalProperties) {
        this.kafkaProperties = kafkaProperties;
        this.tokenCredentialResolver = resolver;
        this.defaultTokenCredential = defaultTokenCredential;
        this.azureGlobalProperties = azureGlobalProperties;
    }

    @Bean
    DefaultKafkaConsumerFactoryCustomizer azureOAuth2KafkaConsumerFactoryCustomizer() {
        HashMap<String, Object> updateConfigs = new HashMap<String, Object>();
        Map consumerProperties = this.kafkaProperties.buildConsumerProperties();
        if (AzureKafkaConfigurationUtils.needConfigureSaslOAuth(consumerProperties)) {
            this.configureOAuth2Properties(consumerProperties, updateConfigs);
            AzureKafkaConfigurationUtils.configureKafkaUserAgent();
        }
        return factory -> factory.updateConfigs(updateConfigs);
    }

    @Bean
    DefaultKafkaProducerFactoryCustomizer azureOAuth2KafkaProducerFactoryCustomizer() {
        HashMap<String, Object> updateConfigs = new HashMap<String, Object>();
        Map producerProperties = this.kafkaProperties.buildProducerProperties();
        if (AzureKafkaConfigurationUtils.needConfigureSaslOAuth(producerProperties)) {
            this.configureOAuth2Properties(producerProperties, updateConfigs);
            AzureKafkaConfigurationUtils.configureKafkaUserAgent();
        }
        return factory -> factory.updateConfigs(updateConfigs);
    }

    private void configureOAuth2Properties(Map<String, Object> sourceKafkaProperties, Map<String, Object> updateConfigs) {
        AzurePasswordlessProperties azurePasswordlessProperties = AzureKafkaConfigurationUtils.buildAzureProperties(sourceKafkaProperties, this.azureGlobalProperties);
        updateConfigs.put("azure.token.credential", this.resolveSpringCloudAzureTokenCredential(azurePasswordlessProperties));
        updateConfigs.putAll(AzureKafkaConfigurationUtils.KAFKA_OAUTH_CONFIGS);
        AzureKafkaConfigurationUtils.logConfigureOAuthProperties();
    }

    private TokenCredential resolveSpringCloudAzureTokenCredential(AzurePasswordlessProperties azurePasswordlessProperties) {
        TokenCredential tokenCredential = this.tokenCredentialResolver.resolve((AzureProperties)azurePasswordlessProperties);
        return tokenCredential == null ? this.defaultTokenCredential : tokenCredential;
    }
}

