/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.spring.cloud.autoconfigure.kafka.AzureKafkaSpringCloudStreamConfiguration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.StringUtils;

class BindingServicePropertiesBeanPostProcessor
implements BeanPostProcessor {
    static final String SPRING_MAIN_SOURCES_PROPERTY = "spring.main.sources";
    private static final String KAKFA_BINDER_DEFAULT_NAME = "kafka";
    private static final String KAKFA_BINDER_TYPE = "kafka";

    BindingServicePropertiesBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof BindingServiceProperties) {
            BindingServiceProperties bindingServiceProperties = (BindingServiceProperties)bean;
            if (bindingServiceProperties.getBinders().isEmpty()) {
                BinderProperties kafkaBinderSourceProperty = new BinderProperties();
                this.configureBinderSources(this.readSpringMainPropertiesMap(kafkaBinderSourceProperty.getEnvironment()));
                HashMap<String, BinderProperties> kafkaBinderPropertyMap = new HashMap<String, BinderProperties>();
                kafkaBinderPropertyMap.put("kafka", kafkaBinderSourceProperty);
                bindingServiceProperties.setBinders(kafkaBinderPropertyMap);
            } else {
                for (Map.Entry entry : bindingServiceProperties.getBinders().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || !"kafka".equalsIgnoreCase(((BinderProperties)entry.getValue()).getType()) && !"kafka".equalsIgnoreCase((String)entry.getKey())) continue;
                    this.configureBinderSources(this.readSpringMainPropertiesMap(((BinderProperties)entry.getValue()).getEnvironment()));
                }
            }
        }
        return bean;
    }

    void configureBinderSources(Map<String, Object> originalSources) {
        StringBuilder sources = new StringBuilder(AzureKafkaSpringCloudStreamConfiguration.AZURE_KAFKA_SPRING_CLOUD_STREAM_CONFIGURATION_CLASS);
        if (StringUtils.hasText((String)((String)originalSources.get("sources")))) {
            sources.append("," + originalSources.get("sources"));
        }
        originalSources.put("sources", sources.toString());
    }

    Map<String, Object> readSpringMainPropertiesMap(Map<String, Object> map) {
        if (map.containsKey("spring")) {
            Map spring = (Map)map.get("spring");
            if (spring.containsKey("main")) {
                return (Map)spring.get("main");
            }
            LinkedHashMap<String, Object> main = new LinkedHashMap<String, Object>();
            spring.put("main", main);
            return main;
        }
        LinkedHashMap<String, Object> main = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> spring = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        spring.put("main", main);
        map.put("spring", spring);
        return main;
    }
}

