/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureKafkaConfigurationUtils;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import com.azure.spring.cloud.service.implementation.passwordless.AzurePasswordlessProperties;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;

class KafkaBinderConfigurationPropertiesBeanPostProcessor
implements BeanPostProcessor {
    private final AzureGlobalProperties azureGlobalProperties;

    KafkaBinderConfigurationPropertiesBeanPostProcessor(AzureGlobalProperties azureGlobalProperties) {
        this.azureGlobalProperties = azureGlobalProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof KafkaBinderConfigurationProperties) {
            KafkaBinderConfigurationProperties binderConfigurationProperties = (KafkaBinderConfigurationProperties)bean;
            Map mergedConsumerConfiguration = binderConfigurationProperties.mergedConsumerConfiguration();
            Map sourceConsumerProperties = binderConfigurationProperties.getConsumerProperties();
            if (AzureKafkaConfigurationUtils.needConfigureSaslOAuth(mergedConsumerConfiguration)) {
                this.configureKafkaBinderProperties(mergedConsumerConfiguration, sourceConsumerProperties);
                AzureKafkaConfigurationUtils.configureKafkaUserAgent();
            }
            Map mergedProducerConfiguration = binderConfigurationProperties.mergedProducerConfiguration();
            Map sourceProducerProperties = binderConfigurationProperties.getProducerProperties();
            if (AzureKafkaConfigurationUtils.needConfigureSaslOAuth(mergedProducerConfiguration)) {
                this.configureKafkaBinderProperties(mergedProducerConfiguration, sourceProducerProperties);
                AzureKafkaConfigurationUtils.configureKafkaUserAgent();
            }
            KafkaProperties kafkaProperties = binderConfigurationProperties.getKafkaProperties();
            Map adminProperties = kafkaProperties.buildAdminProperties();
            KafkaTopicProvisioner.normalalizeBootPropsWithBinder((Map)adminProperties, (KafkaProperties)kafkaProperties, (KafkaBinderConfigurationProperties)binderConfigurationProperties);
            if (AzureKafkaConfigurationUtils.needConfigureSaslOAuth(adminProperties)) {
                this.configureKafkaBinderProperties(adminProperties, binderConfigurationProperties.getConfiguration());
                AzureKafkaConfigurationUtils.configureKafkaUserAgent();
            }
        }
        return bean;
    }

    private void configureKafkaBinderProperties(Map<String, Object> mergedConfiguration, Map<String, String> sourceProperties) {
        AzurePasswordlessProperties azurePasswordlessProperties = AzureKafkaConfigurationUtils.buildAzureProperties(mergedConfiguration, this.azureGlobalProperties);
        AzureKafkaPropertiesUtils.convertAzurePropertiesToConfigMap((AzurePasswordlessProperties)azurePasswordlessProperties, sourceProperties);
        AzureKafkaConfigurationUtils.configureOAuthProperties(sourceProperties);
        AzureKafkaConfigurationUtils.logConfigureOAuthProperties();
    }
}

