/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

@Configuration
public class RestTemplateProxyCustomizerConfiguration {
    public static final SimpleClientHttpRequestFactory FACTORY = RestTemplateProxyCustomizerConfiguration.createProxyFactory();

    @Bean
    public RestTemplateCustomizer proxyRestTemplateCustomizer() {
        return restTemplate -> restTemplate.setRequestFactory((ClientHttpRequestFactory)FACTORY);
    }

    static SimpleClientHttpRequestFactory createProxyFactory() {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8080));
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setProxy(proxy);
        return factory;
    }
}

