/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.cloudfoundry;

import com.azure.spring.cloud.autoconfigure.cloudfoundry.AzureCfService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class AzureCloudFoundryEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(AzureCloudFoundryEnvironmentPostProcessor.class);
    private static final String VCAP_SERVICES_ENVVAR = "VCAP_SERVICES";
    private static final JsonParser PARSER = JsonParserFactory.getJsonParser();
    private static final int ORDER = -2147483639;

    private static Properties retrieveCfProperties(Map<String, Object> vcapMap, AzureCfService azureCfService) {
        Properties properties = new Properties();
        try {
            List serviceBindings = (List)vcapMap.get(azureCfService.getCfServiceName());
            if (serviceBindings == null) {
                return properties;
            }
            if (serviceBindings.size() != 1) {
                LOG.warn("The service " + azureCfService.getCfServiceName() + " has to be bound to a Cloud Foundry application once and only once.");
                return properties;
            }
            Map serviceBinding = (Map)serviceBindings.get(0);
            Map credentialsMap = (Map)serviceBinding.get("credentials");
            azureCfService.getCfToAzureProperties().forEach((cfPropKey, azurePropKey) -> properties.put(azurePropKey, credentialsMap.get(cfPropKey)));
        }
        catch (ClassCastException e) {
            LOG.warn("Unexpected format of CF (VCAP) properties", (Throwable)e);
        }
        return properties;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (StringUtils.hasText((String)environment.getProperty(VCAP_SERVICES_ENVVAR))) {
            Map vcapMap = PARSER.parseMap(environment.getProperty(VCAP_SERVICES_ENVVAR));
            Properties azureCfServiceProperties = new Properties();
            HashSet<AzureCfService> servicesToMap = new HashSet<AzureCfService>(Arrays.asList(AzureCfService.values()));
            servicesToMap.forEach(service -> azureCfServiceProperties.putAll((Map<?, ?>)AzureCloudFoundryEnvironmentPostProcessor.retrieveCfProperties(vcapMap, service)));
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("azureCf", azureCfServiceProperties));
        }
    }

    public int getOrder() {
        return -2147483639;
    }
}

