/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.jms.properties;

import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.jms.support.QosSettings;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jms.servicebus")
public class AzureServiceBusJmsProperties
implements InitializingBean {
    public static final String PREFIX = "spring.jms.servicebus";
    private boolean enabled = true;
    private String connectionString;
    private String topicClientId;
    private Duration idleTimeout = Duration.ofMinutes(30L);
    private String pricingTier;
    private final Listener listener = new Listener();
    private final PrefetchPolicy prefetchPolicy = new PrefetchPolicy();
    @NestedConfigurationProperty
    private final JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getTopicClientId() {
        return this.topicClientId;
    }

    public void setTopicClientId(String topicClientId) {
        this.topicClientId = topicClientId;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Listener getListener() {
        return this.listener;
    }

    public PrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.connectionString)) {
            throw new IllegalArgumentException("'spring.jms.servicebus.connection-string' should be provided");
        }
        if (null == this.pricingTier || !this.pricingTier.matches("(?i)premium|standard|basic")) {
            throw new IllegalArgumentException("'spring.jms.servicebus.pricing-tier' is not valid");
        }
    }

    public static class Listener {
        private Boolean replyPubSubDomain;
        private QosSettings replyQosSettings;
        private Boolean subscriptionDurable = Boolean.TRUE;
        private Boolean subscriptionShared;
        private Integer phase;

        public Boolean isReplyPubSubDomain() {
            return this.replyPubSubDomain;
        }

        public void setReplyPubSubDomain(Boolean replyPubSubDomain) {
            this.replyPubSubDomain = replyPubSubDomain;
        }

        public QosSettings getReplyQosSettings() {
            return this.replyQosSettings;
        }

        public void setReplyQosSettings(QosSettings replyQosSettings) {
            this.replyQosSettings = replyQosSettings;
        }

        public Boolean isSubscriptionDurable() {
            return this.subscriptionDurable;
        }

        public void setSubscriptionDurable(Boolean subscriptionDurable) {
            this.subscriptionDurable = subscriptionDurable;
        }

        public Boolean isSubscriptionShared() {
            return this.subscriptionShared;
        }

        public void setSubscriptionShared(Boolean subscriptionShared) {
            this.subscriptionShared = subscriptionShared;
        }

        public Integer getPhase() {
            return this.phase;
        }

        public void setPhase(Integer phase) {
            this.phase = phase;
        }
    }

    public static class PrefetchPolicy {
        private int all = 0;
        private int durableTopicPrefetch = 0;
        private int queueBrowserPrefetch = 0;
        private int queuePrefetch = 0;
        private int topicPrefetch = 0;

        public int getAll() {
            return Math.max(this.all, 0);
        }

        public void setAll(int all) {
            this.all = all;
        }

        public int getDurableTopicPrefetch() {
            return this.durableTopicPrefetch > 0 ? this.durableTopicPrefetch : this.getAll();
        }

        public void setDurableTopicPrefetch(int durableTopicPrefetch) {
            this.durableTopicPrefetch = durableTopicPrefetch;
        }

        public int getQueueBrowserPrefetch() {
            return this.queueBrowserPrefetch > 0 ? this.queueBrowserPrefetch : this.getAll();
        }

        public void setQueueBrowserPrefetch(int queueBrowserPrefetch) {
            this.queueBrowserPrefetch = queueBrowserPrefetch;
        }

        public int getQueuePrefetch() {
            return this.queuePrefetch > 0 ? this.queuePrefetch : this.getAll();
        }

        public void setQueuePrefetch(int queuePrefetch) {
            this.queuePrefetch = queuePrefetch;
        }

        public int getTopicPrefetch() {
            return this.topicPrefetch > 0 ? this.topicPrefetch : this.getAll();
        }

        public void setTopicPrefetch(int topicPrefetch) {
            this.topicPrefetch = topicPrefetch;
        }
    }
}

