/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultJcaProvider;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.jca.KeyVaultSslManagerBundle;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.jca.properties.AzureKeyVaultJcaProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.jca.properties.AzureKeyVaultSslBundleProperties;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.ssl.SslBundleRegistrar;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AzureKeyVaultSslBundleRegistrar
implements SslBundleRegistrar,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureKeyVaultSslBundleRegistrar.class);
    private ResourceLoader resourceLoader;
    private final Map<String, AzureKeyVaultJcaProperties.JcaVaultProperties> jcaVaults;
    private final Map<String, AzureKeyVaultSslBundleProperties.KeyVaultSslBundleProperties> sslBundles;
    private static final String[] JCA_SYSTEM_PROPERTY_KEYS = new String[]{"azure.keyvault.uri", "azure.keyvault.tenant-id", "azure.keyvault.client-id", "azure.keyvault.client-secret", "azure.keyvault.managed-identity", "azure.keyvault.jca.certificates-refresh-interval", "azure.keyvault.jca.refresh-certificates-when-have-un-trust-certificate", "azure.cert-path.well-known", "azure.cert-path.custom"};

    public AzureKeyVaultSslBundleRegistrar(AzureKeyVaultJcaProperties azureKeyVaultJcaProperties, AzureKeyVaultSslBundleProperties azureKeyVaultSslBundleProperties) {
        this.jcaVaults = azureKeyVaultJcaProperties.getVaults();
        this.sslBundles = azureKeyVaultSslBundleProperties.getKeyvault();
    }

    public void registerBundles(SslBundleRegistry registry) {
        if (!AzureKeyVaultSslBundleRegistrar.hasKeyVaultJcaOnClasspath()) {
            LOGGER.debug("Skip configuring Key Vault SSL bundles because {}", (Object)"'com.azure:azure-security-keyvault-jca' doesn't exist in classpath.");
            return;
        }
        if (this.sslBundles.isEmpty()) {
            LOGGER.debug("Skip configuring Key Vault SSL bundles because {}", (Object)"'spring.ssl.bundle.azure-keyvault' is empty.");
            return;
        }
        AtomicBoolean providerConfigured = new AtomicBoolean(false);
        this.sslBundles.forEach((bundleName, bundle) -> {
            boolean anyCertConfigured;
            boolean hasAnyCertConfiguredForTruststore = AzureKeyVaultSslBundleRegistrar.hasAnyCertConfigured(this.jcaVaults, bundle.getTruststore());
            boolean hasAnyCertConfiguredForKeyStore = AzureKeyVaultSslBundleRegistrar.hasAnyCertConfigured(this.jcaVaults, bundle.getKeystore());
            boolean bl = anyCertConfigured = hasAnyCertConfiguredForTruststore || hasAnyCertConfiguredForKeyStore;
            if (!anyCertConfigured) {
                LOGGER.debug("Skip configuring Key Vault SSL bundle '{}'. Consider configuring 'keyvault-ref', 'certificate-paths.custom' or 'certificate-paths.well-known' properties of the keystore or truststore.", bundleName);
                return;
            }
            KeyStore keyVaultKeyStore = this.initilizeKeyVaultKeyStore("keystore", (String)bundleName, hasAnyCertConfiguredForKeyStore, providerConfigured, this.jcaVaults.get(bundle.getKeystore().getKeyvaultRef()), bundle.getKeystore());
            KeyStore keyVaultTruststore = this.initilizeKeyVaultKeyStore("truststore", (String)bundleName, hasAnyCertConfiguredForTruststore, providerConfigured, this.jcaVaults.get(bundle.getTruststore().getKeyvaultRef()), bundle.getTruststore());
            SslStoreBundle sslStoreBundle = SslStoreBundle.of((KeyStore)keyVaultKeyStore, null, (KeyStore)keyVaultTruststore);
            SslBundleKey sslBundleKey = Optional.ofNullable(bundle.getKey()).map(k -> SslBundleKey.of((String)k.getPassword(), (String)k.getAlias())).orElse(SslBundleKey.NONE);
            SslOptions sslOptions = Optional.ofNullable(bundle.getOptions()).map(o -> SslOptions.of((Set)o.getCiphers(), (Set)o.getEnabledProtocols())).orElse(SslOptions.NONE);
            SslBundle sslBundle = SslBundle.of((SslStoreBundle)sslStoreBundle, (SslBundleKey)sslBundleKey, (SslOptions)sslOptions, (String)bundle.getProtocol(), (SslManagerBundle)new KeyVaultSslManagerBundle(sslStoreBundle, sslBundleKey, bundle.isForClientAuth()));
            registry.registerBundle(bundleName, sslBundle);
            LOGGER.debug("Registered Azure Key Vault SSL bundle '{}'.", bundleName);
        });
    }

    private KeyStore initilizeKeyVaultKeyStore(String storeName, String bundleName, boolean anyCertConfigured, AtomicBoolean providerConfigured, AzureKeyVaultJcaProperties.JcaVaultProperties jcaVaultProperties, AzureKeyVaultSslBundleProperties.KeyStoreProperties keyStoreProperties) {
        KeyStore azureKeyVaultKeyStore;
        if (!anyCertConfigured) {
            LOGGER.debug("The {} parameter of Key Vault SSL bundle '{}' is null.", (Object)storeName, (Object)bundleName);
            return null;
        }
        AzureKeyVaultSslBundleRegistrar.configureJcaKeyStoreSystemProperties(jcaVaultProperties, keyStoreProperties, this.resourceLoader);
        if (providerConfigured.compareAndSet(false, true)) {
            Security.removeProvider("AzureKeyVault");
            Security.insertProviderAt((Provider)new KeyVaultJcaProvider(), 1);
        }
        try {
            azureKeyVaultKeyStore = AzureKeyVaultSslBundleRegistrar.hasEmbeddedTomcat() ? KeyStore.getInstance("DKS", "AzureKeyVault") : KeyStore.getInstance("AzureKeyVault");
            azureKeyVaultKeyStore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new RuntimeException("Failed to load Key Vault " + storeName + " for SSL bundle '" + bundleName + "'", e);
        }
        return azureKeyVaultKeyStore;
    }

    private static boolean hasKeyVaultJcaOnClasspath() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.jca.KeyVaultJcaProvider", (ClassLoader)AzureKeyVaultSslBundleRegistrar.class.getClassLoader());
    }

    private static boolean hasAnyCertConfigured(Map<String, AzureKeyVaultJcaProperties.JcaVaultProperties> jcaVaults, AzureKeyVaultSslBundleProperties.KeyStoreProperties keyStoreProperties) {
        AzureKeyVaultSslBundleProperties.CertificatePathsProperties certificatePaths = keyStoreProperties.getCertificatePaths();
        String keyvaultRef = keyStoreProperties.getKeyvaultRef();
        boolean localCertConfigured = StringUtils.hasText((String)certificatePaths.getWellKnown()) || StringUtils.hasText((String)certificatePaths.getCustom());
        boolean keyVaultRefConfigured = StringUtils.hasText((String)keyvaultRef) && jcaVaults.get(keyvaultRef) != null;
        return localCertConfigured || keyVaultRefConfigured;
    }

    private static boolean hasEmbeddedTomcat() {
        try {
            Class.forName("org.apache.tomcat.InstanceManager");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static void configureJcaKeyStoreSystemProperties(AzureKeyVaultJcaProperties.JcaVaultProperties jcaVaultProperties, AzureKeyVaultSslBundleProperties.KeyStoreProperties keyStoreProperties, ResourceLoader resourceLoader) {
        PropertyMapper pm = new PropertyMapper();
        AzureKeyVaultSslBundleRegistrar.clearJcaSystemProperties();
        if (jcaVaultProperties != null) {
            pm.from((Object)jcaVaultProperties.getEndpoint()).when(StringUtils::hasText).to(v -> System.setProperty("azure.keyvault.uri", v));
            pm.from((Object)jcaVaultProperties.getProfile().getTenantId()).when(StringUtils::hasText).to(v -> System.setProperty("azure.keyvault.tenant-id", v));
            String clientId = jcaVaultProperties.getCredential().getClientId();
            pm.from((Object)clientId).when(StringUtils::hasText).to(v -> System.setProperty("azure.keyvault.client-id", v));
            pm.from((Object)jcaVaultProperties.getCredential().getClientSecret()).when(StringUtils::hasText).to(v -> System.setProperty("azure.keyvault.client-secret", v));
            pm.from((Object)(jcaVaultProperties.getCredential().isManagedIdentityEnabled() && StringUtils.hasText((String)clientId) ? 1 : 0)).whenTrue().to(v -> System.setProperty("azure.keyvault.managed-identity", clientId));
        }
        pm.from((Object)keyStoreProperties.getCertificatesRefreshInterval()).when(Objects::nonNull).to(v -> System.setProperty("azure.keyvault.jca.certificates-refresh-interval", String.valueOf(v.toMillis())));
        pm.from((Object)keyStoreProperties.isRefreshCertificatesWhenHaveUntrustedCertificate()).to(v -> System.setProperty("azure.keyvault.jca.refresh-certificates-when-have-un-trust-certificate", Boolean.toString(v)));
        pm.from((Object)keyStoreProperties.getCertificatePaths().getWellKnown()).to(v -> AzureKeyVaultSslBundleRegistrar.resolvePath(resourceLoader, v).ifPresent(path -> System.setProperty("azure.cert-path.well-known", path)));
        pm.from((Object)keyStoreProperties.getCertificatePaths().getCustom()).to(v -> AzureKeyVaultSslBundleRegistrar.resolvePath(resourceLoader, v).ifPresent(path -> System.setProperty("azure.cert-path.custom", path)));
    }

    private static void clearJcaSystemProperties() {
        Arrays.stream(JCA_SYSTEM_PROPERTY_KEYS).forEach(System::clearProperty);
    }

    private static Optional<String> resolvePath(ResourceLoader resourceLoader, String path) {
        return Optional.ofNullable(path).filter(p -> p.startsWith("classpath:") || p.startsWith("file:")).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).map(res -> {
            try {
                return res.getFile().getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load the certificate path '" + path + "'", e);
            }
        });
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

