/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.jca.properties;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.ssl.SslBundleProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ssl.bundle")
public class AzureKeyVaultSslBundleProperties {
    public static final String PREFIX = "spring.ssl.bundle";
    private final Map<String, KeyVaultSslBundleProperties> keyvault = new HashMap<String, KeyVaultSslBundleProperties>();

    public Map<String, KeyVaultSslBundleProperties> getKeyvault() {
        return this.keyvault;
    }

    public static class CertificatePathsProperties {
        private String custom;
        private String wellKnown;

        public String getCustom() {
            return this.custom;
        }

        public void setCustom(String custom) {
            this.custom = custom;
        }

        public String getWellKnown() {
            return this.wellKnown;
        }

        public void setWellKnown(String wellKnown) {
            this.wellKnown = wellKnown;
        }
    }

    public static class KeyStoreProperties {
        private String keyvaultRef;
        private boolean refreshCertificatesWhenHaveUntrustedCertificate;
        private Duration certificatesRefreshInterval;
        @NestedConfigurationProperty
        private final CertificatePathsProperties certificatePaths = new CertificatePathsProperties();

        public String getKeyvaultRef() {
            return this.keyvaultRef;
        }

        public void setKeyvaultRef(String keyvaultRef) {
            this.keyvaultRef = keyvaultRef;
        }

        public boolean isRefreshCertificatesWhenHaveUntrustedCertificate() {
            return this.refreshCertificatesWhenHaveUntrustedCertificate;
        }

        public void setRefreshCertificatesWhenHaveUntrustedCertificate(boolean refreshCertificatesWhenHaveUntrustedCertificate) {
            this.refreshCertificatesWhenHaveUntrustedCertificate = refreshCertificatesWhenHaveUntrustedCertificate;
        }

        public Duration getCertificatesRefreshInterval() {
            return this.certificatesRefreshInterval;
        }

        public void setCertificatesRefreshInterval(Duration certificatesRefreshInterval) {
            this.certificatesRefreshInterval = certificatesRefreshInterval;
        }

        public CertificatePathsProperties getCertificatePaths() {
            return this.certificatePaths;
        }
    }

    public static class KeyVaultSslBundleProperties
    extends SslBundleProperties {
        private boolean forClientAuth;
        @NestedConfigurationProperty
        private final KeyStoreProperties keystore = new KeyStoreProperties();
        @NestedConfigurationProperty
        private final KeyStoreProperties truststore = new KeyStoreProperties();

        public boolean isForClientAuth() {
            return this.forClientAuth;
        }

        public void setForClientAuth(boolean forClientAuth) {
            this.forClientAuth = forClientAuth;
        }

        public KeyStoreProperties getKeystore() {
            return this.keystore;
        }

        public KeyStoreProperties getTruststore() {
            return this.truststore;
        }
    }
}

