/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.web;

import com.azure.spring.cloud.feature.management.FeatureManager;
import com.azure.spring.cloud.feature.management.models.Variant;
import java.util.HashMap;
import reactor.core.publisher.Mono;

public class FeatureManagerSnapshot {
    private final FeatureManager featureManager;
    private final HashMap<String, Boolean> requestMap;
    private final HashMap<String, Variant> variantMap;

    public FeatureManagerSnapshot(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.requestMap = new HashMap();
        this.variantMap = new HashMap();
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return Mono.just((Object)featureValue);
        }
        return this.featureManager.isEnabledAsync(feature).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled));
    }

    public Boolean isEnabled(String feature) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return featureValue;
        }
        return (Boolean)this.featureManager.isEnabledAsync(feature).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled)).block();
    }

    public Mono<Boolean> isEnabledAsync(String feature, Object featureContext) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return Mono.just((Object)featureValue);
        }
        return this.featureManager.isEnabledAsync(feature, featureContext).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled));
    }

    public Boolean isEnabled(String feature, Object featureContext) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return featureValue;
        }
        return (Boolean)this.featureManager.isEnabledAsync(feature, featureContext).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled)).block();
    }

    public Mono<Variant> getVariantAsync(String feature) {
        Variant variant = this.variantMap.get(feature);
        if (variant != null) {
            return Mono.just((Object)variant);
        }
        return this.featureManager.getVariantAsync(feature).doOnSuccess(variantObject -> this.variantMap.put(feature, (Variant)variantObject));
    }

    public Variant getVariant(String feature) {
        Variant variant = this.variantMap.get(feature);
        if (variant != null) {
            return variant;
        }
        return (Variant)this.featureManager.getVariantAsync(feature).doOnSuccess(variantObject -> this.variantMap.put(feature, (Variant)variantObject)).block();
    }

    public Mono<Variant> getVariantAsync(String feature, Object featureContext) {
        Variant variant = this.variantMap.get(feature);
        if (variant != null) {
            return Mono.just((Object)variant);
        }
        return this.featureManager.getVariantAsync(feature, featureContext).doOnSuccess(variantObject -> this.variantMap.put(feature, (Variant)variantObject));
    }

    public Variant getVariant(String feature, Object featureContext) {
        Variant variant = this.variantMap.get(feature);
        if (variant != null) {
            return variant;
        }
        return (Variant)this.featureManager.getVariantAsync(feature, featureContext).doOnSuccess(variantObject -> this.variantMap.put(feature, (Variant)variantObject)).block();
    }
}

