/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation;

import com.azure.spring.cloud.feature.management.implementation.models.Feature;
import com.azure.spring.cloud.feature.management.implementation.models.ServerSideFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feature-management")
public class FeatureManagementProperties
extends HashMap<String, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManagementProperties.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
    private static final long serialVersionUID = -1642032123104805346L;
    private static final String FEATURE_FLAG_SNAKE_CASE = "feature_flags";
    private transient Map<String, Feature> featureManagement = new HashMap<String, Feature>();
    private Map<String, Boolean> onOff = new HashMap<String, Boolean>();

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m == null) {
            return;
        }
        this.featureManagement = new HashMap<String, Feature>();
        this.onOff = new HashMap<String, Boolean>();
        this.tryServerSideSchema(m);
        if (this.featureManagement.isEmpty() && this.onOff.isEmpty()) {
            this.tryClientSideSchema(m);
        }
    }

    private void tryServerSideSchema(Map<? extends String, ? extends Object> features) {
        block6: {
            Object featureFlagsObject;
            block5: {
                if (features.keySet().isEmpty()) {
                    return;
                }
                String featureFlagsSectionKey = "";
                for (String string : features.keySet()) {
                    if (!FEATURE_FLAG_SNAKE_CASE.equalsIgnoreCase(string)) continue;
                    featureFlagsSectionKey = string;
                    break;
                }
                if (featureFlagsSectionKey.isEmpty()) {
                    return;
                }
                featureFlagsObject = features.get(featureFlagsSectionKey);
                if (!Map.class.isAssignableFrom(featureFlagsObject.getClass())) break block5;
                Map map = (Map)featureFlagsObject;
                for (String key : map.keySet()) {
                    this.addServerSideFeature(map, key);
                }
                break block6;
            }
            if (!List.class.isAssignableFrom(featureFlagsObject.getClass())) break block6;
            List list = (List)featureFlagsObject;
            for (Object flag : list) {
                this.addServerSideFeature((Map)flag, null);
            }
        }
    }

    private void tryClientSideSchema(Map<? extends String, ? extends Object> features) {
        for (String string : features.keySet()) {
            this.addFeature(features, string, "");
        }
    }

    private void addFeature(Map<? extends String, ? extends Object> features, String key, String combined) {
        Object featureValue = features.get(key);
        if (!((String)combined).isEmpty() && !((String)combined).endsWith(".")) {
            combined = (String)combined + ".";
        }
        if (featureValue instanceof Boolean) {
            this.onOff.put((String)combined + key, (Boolean)featureValue);
        } else {
            Feature feature = null;
            try {
                feature = (Feature)MAPPER.convertValue(featureValue, Feature.class);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Found invalid feature {} with value {}.", (Object)((String)combined + key), (Object)featureValue.toString());
            }
            if (feature != null && feature.getEnabledFor() == null && feature.getKey() == null) {
                if (Map.class.isAssignableFrom(featureValue.getClass())) {
                    features = (Map)featureValue;
                    for (String fKey : features.keySet()) {
                        this.addFeature(features, fKey, (String)combined + key);
                    }
                }
            } else if (feature != null) {
                feature.setKey(key);
                this.featureManagement.put(key, feature);
            }
        }
    }

    private void addServerSideFeature(Map<? extends String, ? extends Object> features, String key) {
        Object featureValue = null;
        featureValue = key != null ? features.get(key) : features;
        ServerSideFeature serverSideFeature = null;
        try {
            LinkedHashMap ff = new LinkedHashMap();
            if (featureValue.getClass().isAssignableFrom(LinkedHashMap.class.getClass())) {
                ff = (LinkedHashMap)featureValue;
            }
            LinkedHashMap conditions = new LinkedHashMap();
            if (ff.containsKey("conditions") && ff.get("conditions").getClass().isAssignableFrom(LinkedHashMap.class.getClass())) {
                conditions = (LinkedHashMap)ff.get("conditions");
            }
            if (conditions.get("client_filters") instanceof List) {
                conditions.put("client_filters", null);
            }
            serverSideFeature = (ServerSideFeature)MAPPER.convertValue(featureValue, ServerSideFeature.class);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Found invalid feature {} with value {}.", (Object)key, (Object)featureValue.toString());
        }
        if (serverSideFeature != null && serverSideFeature.getId() != null) {
            if (serverSideFeature.getConditions() != null && serverSideFeature.getConditions().getClientFilters() != null && serverSideFeature.getConditions().getClientFilters().size() > 0) {
                Feature feature = new Feature();
                feature.setKey(serverSideFeature.getId());
                feature.setEvaluate(serverSideFeature.isEnabled());
                feature.setEnabledFor(serverSideFeature.getConditions().getClientFilters());
                feature.setRequirementType(serverSideFeature.getConditions().getRequirementType());
                this.featureManagement.put(serverSideFeature.getId(), feature);
            } else {
                this.onOff.put(serverSideFeature.getId(), serverSideFeature.isEnabled());
            }
        }
    }

    public Map<String, Feature> getFeatureManagement() {
        return this.featureManagement;
    }

    public Map<String, Boolean> getOnOff() {
        return this.onOff;
    }
}

