/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.connectionstring;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.AuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationKey;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.resourcemanager.connectionstring.ArmConnectionStringProvider;
import com.azure.spring.resourcemanager.implementation.crud.EventHubNamespaceCrud;

public class EventHubsArmConnectionStringProvider
extends ArmConnectionStringProvider<AzureServiceType.EventHubs> {
    private final String namespace;
    private final EventHubNamespaceCrud eventHubNamespaceCrud;

    public EventHubsArmConnectionStringProvider(AzureResourceManager resourceManager, AzureResourceMetadata resourceMetadata, String namespace) {
        super(resourceManager, resourceMetadata);
        this.namespace = namespace;
        this.eventHubNamespaceCrud = new EventHubNamespaceCrud(resourceManager, resourceMetadata);
    }

    public String getConnectionString() {
        return ((EventHubNamespace)this.eventHubNamespaceCrud.get(this.namespace)).listAuthorizationRules().stream().findFirst().map(AuthorizationRule::getKeys).map(EventHubAuthorizationKey::primaryConnectionString).orElseThrow(() -> new RuntimeException(String.format("Failed to fetch connection string of namespace '%s'", this.namespace), null));
    }

    public AzureServiceType.EventHubs getServiceType() {
        return AzureServiceType.EVENT_HUBS;
    }
}

