/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.connectionstring;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.AuthorizationKeys;
import com.azure.resourcemanager.servicebus.models.AuthorizationRule;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.resourcemanager.connectionstring.ArmConnectionStringProvider;
import com.azure.spring.resourcemanager.implementation.crud.ServiceBusNamespaceCrud;

public class ServiceBusArmConnectionStringProvider
extends ArmConnectionStringProvider<AzureServiceType.ServiceBus> {
    private final String namespace;
    private final ServiceBusNamespaceCrud serviceBusNamespaceCrud;

    public ServiceBusArmConnectionStringProvider(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata, String namespace) {
        super(azureResourceManager, azureResourceMetadata);
        this.namespace = namespace;
        this.serviceBusNamespaceCrud = new ServiceBusNamespaceCrud(azureResourceManager, azureResourceMetadata);
    }

    public String getConnectionString() {
        return ((ServiceBusNamespace)this.serviceBusNamespaceCrud.get(this.namespace)).authorizationRules().list().stream().findFirst().map(AuthorizationRule::getKeys).map(AuthorizationKeys::primaryConnectionString).orElseThrow(() -> new RuntimeException(String.format("Service bus namespace '%s' key is empty", this.namespace), null));
    }

    public AzureServiceType.ServiceBus getServiceType() {
        return AzureServiceType.SERVICE_BUS;
    }
}

