/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.connectionstring;

import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.resourcemanager.connectionstring.ArmConnectionStringProvider;
import com.azure.spring.resourcemanager.implementation.crud.StorageAccountCrud;

public class StorageQueueArmConnectionStringProvider
extends ArmConnectionStringProvider<AzureServiceType.StorageQueue> {
    private final String accountName;
    private final StorageAccountCrud storageAccountCrud;

    public StorageQueueArmConnectionStringProvider(AzureResourceManager resourceManager, AzureResourceMetadata resourceMetadata, String accountName) {
        super(resourceManager, resourceMetadata);
        this.accountName = accountName;
        this.storageAccountCrud = new StorageAccountCrud(resourceManager, resourceMetadata);
    }

    public String getConnectionString() {
        return ((StorageAccount)this.storageAccountCrud.get(this.accountName)).getKeys().stream().findFirst().map(key -> ResourceManagerUtils.getStorageConnectionString((String)this.accountName, (String)key.value(), (AzureEnvironment)((StorageManager)this.getAzureResourceManager().storageAccounts().manager()).environment())).orElseThrow(() -> new RuntimeException("Storage account key is empty."));
    }

    public AzureServiceType.StorageQueue getServiceType() {
        return AzureServiceType.STORAGE_QUEUE;
    }
}

