/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.resourcemanager.implementation.crud.AbstractResourceCrud;
import org.springframework.lang.NonNull;

public class ServiceBusNamespaceCrud
extends AbstractResourceCrud<ServiceBusNamespace, String> {
    public ServiceBusNamespaceCrud(@NonNull AzureResourceManager azureResourceManager, @NonNull AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return ServiceBusNamespace.class.getSimpleName();
    }

    @Override
    public ServiceBusNamespace internalGet(String namespace) {
        try {
            return (ServiceBusNamespace)this.resourceManager.serviceBusNamespaces().getByResourceGroup(this.resourceMetadata.getResourceGroup(), namespace);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public ServiceBusNamespace internalCreate(String namespace) {
        return (ServiceBusNamespace)((ServiceBusNamespace.DefinitionStages.WithCreate)((ServiceBusNamespace.DefinitionStages.WithGroup)((ServiceBusNamespace.DefinitionStages.Blank)this.resourceManager.serviceBusNamespaces().define(namespace)).withRegion(this.resourceMetadata.getRegion())).withExistingResourceGroup(this.resourceMetadata.getResourceGroup())).create();
    }
}

