/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.resourcemanager.implementation.crud.ServiceBusNamespaceCrud;
import reactor.util.function.Tuple2;

public class ServiceBusQueueCrud
extends AbstractResourceCrud<Queue, Tuple2<String, String>> {
    public ServiceBusQueueCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(Tuple2<String, String> key) {
        return (String)key.getT2();
    }

    @Override
    String getResourceType() {
        return Queue.class.getSimpleName();
    }

    @Override
    public Queue internalGet(Tuple2<String, String> namespaceAndName) {
        try {
            return (Queue)((ServiceBusNamespace)new ServiceBusNamespaceCrud(this.resourceManager, this.resourceMetadata).get((String)namespaceAndName.getT1())).queues().getByName((String)namespaceAndName.getT2());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Queue internalCreate(Tuple2<String, String> namespaceAndName) {
        return (Queue)((Queue.DefinitionStages.Blank)((ServiceBusNamespace)new ServiceBusNamespaceCrud(this.resourceManager, this.resourceMetadata).getOrCreate((String)namespaceAndName.getT1())).queues().define((String)namespaceAndName.getT2())).create();
    }
}

